VERSION 5.00
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "richtx32.Ocx"
Begin VB.UserControl scannerCtrl 
   ClientHeight    =   3825
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   8550
   ScaleHeight     =   3825
   ScaleWidth      =   8550
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close"
      Height          =   375
      Left            =   5640
      TabIndex        =   3
      Top             =   3240
      Width           =   1455
   End
   Begin VB.Timer tmr_Check 
      Enabled         =   0   'False
      Interval        =   10000
      Left            =   6480
      Top             =   360
   End
   Begin VB.CommandButton cmd_Reset 
      Caption         =   "RAZ"
      Height          =   375
      Left            =   7680
      TabIndex        =   2
      Top             =   2280
      Width           =   855
   End
   Begin VB.CommandButton cmd_Pause 
      Caption         =   "Pause"
      Height          =   375
      Left            =   960
      TabIndex        =   1
      Top             =   3240
      Width           =   1455
   End
   Begin VB.CommandButton cmd_Play 
      Caption         =   "Play"
      Enabled         =   0   'False
      Height          =   375
      Left            =   2520
      TabIndex        =   0
      Top             =   3240
      Width           =   1455
   End
   Begin RichTextLib.RichTextBox txtLog 
      Height          =   2175
      Left            =   0
      TabIndex        =   4
      Top             =   0
      Width           =   8535
      _ExtentX        =   15055
      _ExtentY        =   3836
      _Version        =   393217
      Enabled         =   -1  'True
      ReadOnly        =   -1  'True
      ScrollBars      =   2
      TextRTF         =   $"scannerCtrl.ctx":0000
   End
   Begin VB.Label lbl_OneUser 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Mails sent to only one user : 0"
      Height          =   375
      Left            =   0
      TabIndex        =   6
      Top             =   2280
      Width           =   7575
   End
   Begin VB.Label lbl_Task 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Actual task :"
      Height          =   375
      Left            =   0
      TabIndex        =   5
      Top             =   2760
      Width           =   8535
   End
End
Attribute VB_Name = "scannerCtrl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'What is new:
' 2.1.4  JN Allow ; as separator in email address
' 2.1.4  JN supress blocking the processign by failed emails


' **************************************************************************************************
' **************************************** TOOL CONSTANTS ******************************************
' **************************************************************************************************
    Const ApolloTenantID As String = "55f22949-6163-4931-ae91-aa41b0659f29"
    Const ApplicationID As String = "94ec28e2-66a8-4afd-b809-b879cbd85f57"
    
    Private ms_ApolloTenantID As String
    Private ms_ApplicationID As String

Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SEP As String = SEP1 + SEP2
Private Const C_MODULE_NAME As String = "Internet Mail Scanner"      ' module name used in log table
Private Const C_LOGTXTMAX As Long = 10 * 1024               ' 10 kb of text to display
Private Const C_PROCESSNAME As String = "INTERNETMAIL" ' for heartbeat
Private Const C_UNKNOWN_SENDER As String = "Unknown sender"     ' indicate unknown sender
' ****************************************** TOOL CONSTANTS ***************************************

' **************************************************************************************************
' **************************************** USER DEFINED ERRORS *************************************
' **************************************************************************************************
Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1              ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2    ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3        ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    FileLoadFailed = vbObjectError + 13          ' failed to load file
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private Enum ArmSysType
  DBTYPE_EMPTY = 0
  DBTYPE_I4 = 3
  DBTYPE_R4 = 4
  DBTYPE_R8 = 5
  DBTYPE_DATE = 7
  DBTYPE_BSTR = 8 '- UNICODE string
  DBTYPE_BOOL = 11
  DBTYPE_STR = 129
  DBTYPE_BMP = 999
End Enum
' *************************************** USER DEFINED ERRORS **************************************

' **************************************************************************************************
' *************************************** CONTROL MEMBERS ******************************************
' **************************************************************************************************
' common global variables
Private ms_LanguageCode                 As String   ' Language code
Private mb_Initialized                  As Boolean  ' Initialized user control flag
Private mb_Initializing                 As Boolean  ' Flag of initializing
Private ms_LoginName                    As String   ' login name
Private ml_UserCode                     As Long     ' User code
Private ml_LogEX                        As Long     ' Create extended log   JN 3.8.2007

Dim ms_SERVER                           As String   ' database server
Dim ms_DATABASE                         As String   ' database name
Dim ms_USER                             As String   ' database user
Dim ms_PASSWORD                         As String   ' database password


Dim msArmMail()                         As String   ' Liste de mail armstrong
Dim msDestMailTo()                      As String   ' Liste des personnes en rponse directe
Dim msDestMailCopy()                    As String   ' Liste des personnes en rponse copie
Dim mbProgID                            As Boolean  ' Nature de la prochaine tache
Dim mva_spamArray                       As Variant  ' SPAM definitions Array
                                    
Dim msNotifPath                         As String   ' Chemin du serveur Mail
Dim msNotifLogin                        As String   ' Login pour le mail de notif
Dim msNotifPassword                     As String   ' Password pour le mail de notif
Dim msNotifTitle                        As String   ' Titre du mail de notif
Dim msNotifMessage                      As String   ' Corps du message du mail de notif
Dim msDefaultcharset                    As String   ' charset du mail par dfaut

Dim msMailBox()                         As String   ' Liste des boites aux lettres  scruter
Dim miMailIndex                         As Integer  ' Index de la mailbox courante
Dim miMailMaxIndex                      As Integer  ' Index maxi des mailboxes

Dim msMailAttachmentPath                As String   ' Chemin des pices jointes

Dim msCloseInfoAddress                  As String   ' Adresse de la personne  informer en cas de fermeture de l'appli
Dim msEnvironment                       As String   ' Nom de l'environnement (Devel, Test, Live)

Dim msDefaultKeyFilename                As String   ' Configuration de notes.ini pour les mails de notif
Dim msDefaultCertificateExpChecked      As String
Dim msDefaultMailFile                   As String
Dim msDefaultLocation                   As String
Dim msDefaultNewMailSeqNum              As String

Dim mva_placeHolders()                  As Variant  ' array of defined placeholders

Const IDSM_ITM_STATE = 11                           ' Constantes du composant de mail
Const IDSM_ITM_RAW_HEADERS = 21
Const IDSM_STATE_READ = 0
Const IDSM_STATE_UNREAD = -1
Const IDSM_ITM_TO = 1
Const IDSM_ITM_CC = 2

Dim ml_OneUser                          As Long     ' Nombre de mails envoys  seulement un utilisateur
Dim mb_DirectMailFound                  As Boolean  ' Indique si un mail direct a t trouv

' ArmExchange
Private WithEvents mo_Exchange As ArmGraph      ' ArmExchange
Attribute mo_Exchange.VB_VarHelpID = -1

' HeartBeat support >>
Dim mo_HeartBeat            As HeartBeat
Private Const mb_IgnoreHeartBeatForDebbuging As Boolean = True
' <<

' sets of sql result count types
Private Enum ArmSQLResultType
    ArmSQLExactOne                      ' 1..1
    ArmSQLMaxOne                        ' 0..1
    ArmSQLAtLeastOne                    ' 1..N
    ArmSQLAny                           ' 0..N
End Enum

#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDB
#End If

    Dim mo_FSO As Object                ' filesystem object

' *************************************** CONTROL MEMBERS ******************************************

' **************************************************************************************************
' *********************************** PUBLIC CONTROL EVENTS ****************************************
' **************************************************************************************************
Public Event quit()

' *********************************** PUBLIC CONTROL EVENTS ****************************************


' **************************************************************************************************
' ********************************* PUBLIC CONTROL PROPERTIES **************************************
' **************************************************************************************************
' database controler property
' Params:
' ao_db (ARMSYSCOMLib.ArmDb) - ArmSysCom instance
#If LIVE Then
Public Property Set Db(ByRef ao_DB As Object)
#Else
Public Property Set Db(ByRef ao_DB As ARMSYSCOMLib.ArmDB)
#End If

On Error GoTo ErrHandler
    If Not mo_Db Is Nothing Then Err.Raise ArmErr.CPTAlreadyInitialized
    If ao_DB Is Nothing Then Err.Raise ArmErr.InvalidArgument
    
    Set mo_Db = ao_DB
    
    Exit Property
ErrHandler:
    Call ErrorMessage(Extender.Name & ".ArmDb(Set)")
End Property

Public Property Let LoginName(ByVal as_loginName As String)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ms_LoginName = as_loginName
    Exit Property
ErrHandler:
    Call ErrorMessage(Extender.Name & ".LoginName(Let)")
End Property

' User code used in logs
Public Property Let U_Code(ByVal al_UserCode As Long)
On Error GoTo ErrHandler
    
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ml_UserCode = al_UserCode
    Exit Property
ErrHandler:
    Call ErrorMessage(Extender.Name & ".U_Code(Let)")
End Property

' Setting language code
Public Property Let Language_Code(ByVal as_newValue As String)
On Error GoTo ErrHandler
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If Len(as_newValue) <> 1 Then Call Err.Raise(ArmErr.InvalidArgument, "", "Language_code must contains only 1 char")
    
    ms_LanguageCode = as_newValue
    
    Exit Property
ErrHandler:
     Call ErrorMessage(Extender.Name & ".Language_Code")
End Property

' Set Extended log
Public Property Let LogEx(ByVal al_logEx As Long)
On Error GoTo ErrHandler
    If mb_Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    ml_LogEX = al_logEx
    Exit Property
ErrHandler:
     Call ErrorMessage(Extender.Name & ".LogEx")
End Property

' ********************************* PUBLIC CONTROL PROPERTIES **************************************


' **************************************************************************************************
' ******************************* PUBLIC USER CONTROL METHODS **************************************
' **************************************************************************************************
' initialize user control
Public Function Load_A_COM()
Dim ls_Text As String

    On Error GoTo ErrHandler
    Load_A_COM = False
    
    If mb_Initialized Then Err.Raise ArmErr.CPTAlreadyInitialized
    If mo_Db Is Nothing Then Err.Raise ArmErr.PropertyNotSet, "ArmDb not initialized"
    If ms_LanguageCode = "" Then Err.Raise ArmErr.PropertyNotSet, "LanguageCode not initialized"
    'If ml_UserCode = 0 Then Err.Raise ArmErr.PropertyNotSet, "UserCode not initialized"
    
    Set mo_FSO = CreateObject("Scripting.FileSystemObject")
    
    ' init placeholders array
    ReDim mva_placeHolders(0) As Variant        ' at least one atom is required
    mva_placeHolders(0) = Array("CHARSET", Empty)    ' charset of email
    
    ms_ApolloTenantID = ApolloTenantID
    ms_ApplicationID = ApplicationID
    
    Dim ls_SaveMessageOnSend As String
    ls_SaveMessageOnSend = "FALSE"
    
    
    ' Rcupre la configuration
    Open App.Path & "\config.txt" For Input As #1
    While Not EOF(1)
        Line Input #1, ls_Text
        Select Case GetBeforeEqual(ls_Text)
        Case "Tenant"                           ' apollo tenant
            ms_ApolloTenantID = GetAfterEqual(ls_Text)
        Case "AppID"                            ' GMail app id
            ms_ApplicationID = GetAfterEqual(ls_Text)
        Case "Notif path"                       ' Chemin du serveur de messagerie pour les mails de notif
            msNotifPath = GetAfterEqual(ls_Text)
        Case "Notif login"                      ' Login du compte de mail de notif
            msNotifLogin = GetAfterEqual(ls_Text)
        Case "Notif password"                   ' Mot de passe du compte de mail de notif
            msNotifPassword = GetAfterEqual(ls_Text)
        Case "Notif title"                      ' Titre du mail de notif
            msNotifTitle = GetAfterEqual(ls_Text)
        Case "Notif message"                    ' Contenu du mail de notif
            msNotifMessage = GetAfterEqual(ls_Text)
        Case "Default charset"                  ' charset du mail
            msDefaultcharset = GetAfterEqual(ls_Text)
        Case "KeyFilename"                      ' Config du mail de notif
            msDefaultKeyFilename = GetAfterEqual(ls_Text)
        Case "CertificateExpChecked"            ' Config du mail de notif
            msDefaultCertificateExpChecked = GetAfterEqual(ls_Text)
        Case "MailFile"                         ' Config du mail de notif
            msDefaultMailFile = GetAfterEqual(ls_Text)
        Case "Location"                         ' Config du mail de notif
            msDefaultLocation = GetAfterEqual(ls_Text)
        Case "SaveMessageOnSend"
            ls_SaveMessageOnSend = GetAfterEqual(ls_Text)
        Case "NewMailSeqNum"                    ' Config du mail de notif
            msDefaultNewMailSeqNum = GetAfterEqual(ls_Text)
        Case "MailAttachmentPath"               ' Chemin des pices jointes sur le serveur FTP
            msMailAttachmentPath = GetAfterEqual(ls_Text)
        Case "CloseWarningAddress"              ' Adresse de la personne  informer en cas de fermeture de l'appli
            msCloseInfoAddress = GetAfterEqual(ls_Text)
        Case "Environment"                      ' Nom de l'environnement (Devel, Test, Live)
            msEnvironment = GetAfterEqual(ls_Text)
        Case "DBServer"                         ' database server
            ms_SERVER = GetAfterEqual(ls_Text)
        Case "DBName"                           ' database name
            ms_DATABASE = GetAfterEqual(ls_Text)
        Case "DBUser"                           ' database user
            ms_USER = GetAfterEqual(ls_Text)
        Case "DBPassword"                       ' database password
            ms_PASSWORD = GetAfterEqual(ls_Text)
        End Select
    Wend
    Close #1
    
    
    Call AddToLog(C_MODULE_NAME & " " & App.Major & "." & App.Minor & "." & App.Revision & " started... param:" & Command & " (parsed logEx=" & ml_LogEX & ")" & vbCrLf, "0", "")
    
    ' ArmExchange
    Set mo_Exchange = New ArmGraph  ' ArmExchange
    mo_Exchange.TenantID = ms_ApolloTenantID
    mo_Exchange.ApplicationID = ms_ApplicationID
    mo_Exchange.SaveMessageOnSend = (ls_SaveMessageOnSend = "TRUE")
    
    Call mo_Exchange.Load_A_COM

    ' Dfinie la liste des messageries  scruter
    DefineMailBoxes
    miMailMaxIndex = UBound(msMailBox, 2)
    miMailIndex = 0
    Call AddToLog("Mail boxes defined" & vbCrLf, "0", "")
    
    ' task 376 begin JN 2.3.2007
    DefineSpam
    txtLog.Text = Left("Spam defined:" & Join(mva_spamArray, ", ") & vbCrLf & txtLog.Text, C_LOGTXTMAX)
    ' task 376 end
        
    ' Heart Beat settings >>
    Set mo_HeartBeat = New HeartBeat
    
    If mo_HeartBeat.HeartBeatConfig(mo_Db, C_PROCESSNAME) = True Then
        ' chck if other instance is running
        If Not mo_HeartBeat.HeartbeatTest(mo_Db, C_PROCESSNAME) Then
            ' exit app
            If mb_IgnoreHeartBeatForDebbuging = False Then
                Call MsgBox("Another instance is running !")
                Call mo_Db.Disconnect
                End
            Else
                Call MsgBox("Heartbeat test ignored! Debbuging mode active.")
            End If
        End If
        
        Call mo_HeartBeat.HeartBeatEnable(mo_Db, C_PROCESSNAME, True)
    Else
        Call AddToLog("Mail Processor HeartBeat configuration error", "0")
    End If
    ' Hear Beat settings <<
    
    mbProgID = True
    tmr_Check.Enabled = True    ' start timer

    mb_Initialized = True

    Load_A_COM = True
    Exit Function
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Load_A_Com")
End Function

' uninitialize user control
Public Sub Unload_A_COM()
On Error GoTo ErrHandler
    Call AddToLog("Mail Scanner shutdown..." & vbCrLf, "0", "")

    mb_Initialized = False

    ' Disable HeartBeat
    If (CheckConnection(mo_Db) = True) Then
        Call mo_HeartBeat.HeartBeatEnable(mo_Db, C_PROCESSNAME, False)
    End If
    
' DEBUG
    Debug.Assert (mo_Db.CursorCount = 0)
    
    Set mo_Db = Nothing
    Set mo_FSO = Nothing
    
    Exit Sub
ErrHandler:
     Call ErrorMessage(Extender.Name & ".Unload_A_COM")
End Sub
' ******************************* PUBLIC USER CONTROL METHODS **************************************


' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, as_Fct & SEP1 & Err.Source, Err.Description, Err.HelpFile, Err.HelpContext
End Sub

' display standard error message
' Params:
' as_Fct (String) - Error CallStack
' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String, Optional ab_Display As Boolean = True)
    If Err.Number = QuietException Then Exit Sub
    Dim ll_oldMP As MousePointerConstants
    
    'save mouse pointer
    ll_oldMP = Screen.MousePointer
    Screen.MousePointer = vbDefault
    
    Dim ls_ErrSource As String
    Dim ls_ErrDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_ErrDescription = Err.Description
    
    Call LogMessage(App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_ErrDescription & ".", "E", False)
    
    If ab_Display Then
        Call MsgBox("Error occured, please contact IT" & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_ErrDescription, , "Error message: " & as_Fct)
    End If
    
    'restore mouse pointer
    Screen.MousePointer = ll_oldMP
End Sub


' logs message to database
Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "I", Optional ab_throwException As Boolean = True)
On Error GoTo ErrHandler
Const InsertReq As String = "EXEC A_log_ins $UCODE$, '$LOGTYPE$', '$MSG$', '$APP$'"
    Dim ls_req As String
    Dim ll_Cursor As Long
    
    ls_req = Replace(InsertReq, "$UCODE$", CStr(ml_UserCode))
    ls_req = Replace(ls_req, "$APP$", SqlStr(C_MODULE_NAME & " " & App.Major & "." & App.Minor & "." & App.Revision, 50))
    ls_req = Replace(ls_req, "$MSG$", SqlStr(as_logMsg, 4000))
    ls_req = Replace(ls_req, "$LOGTYPE$", SqlStr(as_logType), 1)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Exit Sub
ErrHandler:
    If ab_throwException Then Call ErrorHandler(Extender.Name & ".LogMessage - " & Err.Number & ": " & Err.Description)
End Sub

' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************

' ************************************************************************************
' **************************** DB-ACCESS FUNCTIONS ***********************************
' ************************************************************************************
#If LIVE = 1 Then
Public Function CheckConnection(ByVal ao_DB As Object) As Boolean
#Else
Public Function CheckConnection(ByVal ao_DB As ARMSYSCOMLib.ArmDB) As Boolean
#End If
Dim lc_Data As Long
On Error GoTo ErrHandler

    lc_Data = OpenSQLSafe(ao_DB, "SELECT GetDate()")
    ao_DB.Close (lc_Data)
    CheckConnection = True
    Exit Function
ErrHandler:
    mo_Db.Disconnect
    
    If Not mo_Db.Connect(ms_SERVER, ms_DATABASE, ms_USER, ms_PASSWORD, "InternetMailScanner") Then
        Call AddToLog("Connection to db lost.", "0")
    Else
        CheckConnection = True
        Exit Function
    End If
    
    CheckConnection = False
End Function

' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If LIVE = 1 Then
Private Function OpenSQLSafe(ByRef ao_DB As Object, ByVal as_Request As String, Optional ByVal au_SQLResultType As ArmSQLResultType = ArmSQLAny, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByRef ao_DB As ARMSYSCOMLib.ArmDB, ByVal as_Request As String, Optional ByVal au_SQLResultType As ArmSQLResultType = ArmSQLAny, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        ' reconnect server
        Call ao_DB.Disconnect
        Call DBConnect(ao_DB, ms_SERVER, ms_DATABASE, ms_USER, ms_PASSWORD)
        lc_Data = ao_DB.OpenSQL(as_Request)
        
        If lc_Data = 0 Then
            Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
        End If
    End If
    
    Select Case au_SQLResultType
        Case ArmSQLExactOne
            If ao_DB.RowCount(lc_Data) <> 1 Then
                Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, "doesn't match count rule 1..1 with result count: " & ao_DB.RowCount(lc_Data)
            End If
        Case ArmSQLMaxOne
            If ao_DB.RowCount(lc_Data) <> 1 And ao_DB.RowCount(lc_Data) <> 0 Then
                Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, "doesn't match count rule 0..1 with result count: " & ao_DB.RowCount(lc_Data)
            End If
        Case ArmSQLAtLeastOne
            If ao_DB.RowCount(lc_Data) < 1 Then
                Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, "doesn't match count rule 1..N with result count: " & ao_DB.RowCount(lc_Data)
            End If
        Case ArmSQLAny
            If al_RowExpectedCount <> -1 Then
                ' Then check the rowcount
                If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
                    Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data)
                End If
            End If
    End Select
  

    OpenSQLSafe = lc_Data

    Exit Function

ErrHandler:
    If lc_Data <> 0 Then
        Call ao_DB.Close(lc_Data)
        lc_Data = 0
    End If
    
    Call ErrorHandler(Extender.Name & ".OpenSQLSafe")
End Function


' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByRef ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByRef ao_DB As ARMSYSCOMLib.ArmDB, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        If ao_DB.SQLErrorCodes()(0) = 547 Then
            Err.Raise ArmErr.SQLTableReferenceConstraint, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
        End If
        
        ' reconnect server
        Call ao_DB.Disconnect
        Call DBConnect(ao_DB, ms_SERVER, ms_DATABASE, ms_USER, ms_PASSWORD)
        
        ' try after reconnect
        If Not ao_DB.ExecuteSQL(as_Request) Then
            Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
        End If
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            End If
        End If
    End If
    
    Exit Sub

ErrHandler:
    Call ErrorHandler(Extender.Name & ".ExecuteSQLSafe")
End Sub

#If LIVE = 1 Then
Private Sub DBConnect(ByRef ao_DB As Object, ByVal as_SERVER As String, ByVal as_DATABASE As String, ByVal as_USER As String, ByVal as_Pwd As String)
#Else
Private Sub DBConnect(ByRef ao_DB As ARMSYSCOMLib.ArmDB, ByVal as_SERVER As String, ByVal as_DATABASE As String, ByVal as_USER As String, ByVal as_Pwd As String)
#End If
    
On Error GoTo ErrHandler
    
    If Not ao_DB.Connect(as_SERVER, as_DATABASE, as_USER, as_Pwd, App.ProductName & " v." & App.Major & "." & App.Minor & "." & App.Revision) Then
        Debug.Print "Unable to connect to database"
        Debug.Assert (False)
        Err.Raise ArmErr.DBCnxFailed, "", Join(ao_DB.SQLErrorCodes, SEP1) & SEP2 & Join(ao_DB.SQLErrorMessages, SEP1)
    End If
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("DBConnect")
End Sub

Private Function SqlStr(ByVal as_Str As String, Optional ByVal al_maxLen As Long = 8000) As String
    SqlStr = Replace(Left(as_Str, IIf(Len(as_Str) <= al_maxLen, Len(as_Str), al_maxLen)), "'", "''")
End Function

' tranlate date to sql format
' Params:
' ad_Date (Date)
Private Function SQLDateTime(ByVal ad_Date As Date) As String
On Error GoTo ErrHandler
  If ad_Date = 0 Then
    SQLDateTime = "Null"
  Else
    SQLDateTime = "{ ts '" & Format(ad_Date, "yyyy-mm-dd hh:mm:ss") & "'}"
  End If
    Exit Function
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SQLDateTime")
End Function

Private Function SQLNum(ByVal av_Value As Double) As String
On Error GoTo ErrHandler

  SQLNum = Str(av_Value)
  Exit Function
ErrHandler:
  Call ErrorHandler(Extender.Name & ".SQLNum")
End Function
' return array of SQL safe values from cursor
Private Function SQLSafeFromCursor(ByVal al_cursor As Long) As Variant
On Error GoTo ErrHandler
    Dim ll_i As Long
    Dim lv_retVal As Variant
    lv_retVal = mo_Db.GetFields(al_cursor, mo_Db.Fields(al_cursor))
    For ll_i = 0 To UBound(lv_retVal)
        Select Case mo_Db.GetFieldType(al_cursor, ll_i)
            Case DBTYPE_EMPTY
                lv_retVal(ll_i) = ""
            Case DBTYPE_I4, DBTYPE_R4, DBTYPE_R8
                lv_retVal(ll_i) = SQLNum(lv_retVal(ll_i))
            Case DBTYPE_DATE
                lv_retVal(ll_i) = SQLDateTime(lv_retVal(ll_i))
            Case DBTYPE_BSTR
                lv_retVal(ll_i) = "N'" & SqlStr(lv_retVal(ll_i), mo_Db.GetFieldSize(al_cursor, ll_i)) & "'"
            Case DBTYPE_STR
                lv_retVal(ll_i) = "'" & SqlStr(lv_retVal(ll_i), mo_Db.GetFieldSize(al_cursor, ll_i)) & "'"
            Case DBTYPE_BOOL
                lv_retVal(ll_i) = IIf(lv_retVal(ll_i), "TRUE", "FALSE")
            Case Else
                Debug.Assert (False)
        End Select
    Next ll_i
    SQLSafeFromCursor = lv_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLSafeFromCursor")
End Function
' **************************** DB-ACCESS FUNCTIONS ***********************************

' *******************************************************************************
' ************************ DISK IO FUNCTIONS ************************************
' *******************************************************************************
' create directory if not exist
Private Function CreateDirStruct(ByVal strPath As String, ByVal ao_FSO As Object) As Boolean

On Error GoTo Create_Dir_Struct_Errors
    Dim intIndex    As Integer
    Dim strTmpPath  As String
    
    If Len(Trim$(strPath)) = 0 Then
        ' if we specify wrong path it is error
        CreateDirStruct = False
        Exit Function
    End If
    
    If Right$(strPath, 1) <> "\" Then strPath = strPath & "\"
    intIndex = 0
    
    Do
        ' get the next path chunk
        intIndex = InStr(intIndex + 1, strPath, "\")
        
        If intIndex > 0 Then
            strTmpPath = Left$(strPath, intIndex - 1)
        Else
            Exit Do
        End If
        
        ' see if this folder exists
        If Not ao_FSO.FolderExists(strTmpPath) Then
            ' Create this folder.
            ' If there is an error, it will be trapped bellow
            ao_FSO.CreateFolder strTmpPath
            intIndex = 1
        End If
    Loop
    CreateDirStruct = True
    Exit Function

Create_Dir_Struct_Errors:
    Call ErrorHandler(Extender.Name & ".CreateDirStruct()")
End Function

' delete files one by one
Private Function DeleteFiles(ByVal as_Path As String, ByVal as_pattern As String, ao_FSO As Object) As Boolean
  
On Error GoTo KillFiles_Errors
  
    Dim lo_Files    As Object
    Dim lo_folder   As Object
    Dim lo_File     As Object


    Set lo_folder = ao_FSO.GetFolder(as_Path)
    Set lo_Files = lo_folder.Files

    For Each lo_File In lo_Files
        If lo_File.Name Like as_pattern Then Call DeleteFile(lo_File)
    Next
    
    Set lo_File = Nothing
    Set lo_Files = Nothing
    Set lo_folder = Nothing
    
    DeleteFiles = True
    Exit Function
    
KillFiles_Errors:
    ' free resources
    If Not lo_File Is Nothing Then Set lo_File = Nothing
    If Not lo_Files Is Nothing Then Set lo_Files = Nothing
    If Not lo_folder Is Nothing Then Set lo_folder = Nothing
    
    Call ErrorHandler(Extender.Name & ".DeleteFiles()")
End Function

' function will delete file
' if file cannot be deleted, function return false and log event
Private Function DeleteFile(ByVal ao_file As Object) As Boolean
On Error GoTo KillFile_Errors
    Debug.Assert (Not ao_file Is Nothing)
    ao_file.Delete (True)
    DeleteFile = True
    Exit Function
KillFile_Errors:
    Call ErrorHandler(Extender.Name & ".DeleteFile()")
End Function
' ************************ DISK IO FUNCTIONS ************************************


' ************************************************************************************
' ***************************** CONFIG FUNCTIONS *************************************
' ************************************************************************************
' Rcupre la chaine de caractre avant le " = " dans une chaine passe en paramtre
Function GetBeforeEqual(ByVal psText As String) As String
Dim i As Integer
On Error GoTo ErrHandler
    
    i = InStr(1, psText, "=")
    GetBeforeEqual = Left(psText, i - 2)
    
  Exit Function
ErrHandler:
  Call ErrorHandler("GetBeforeEqual")
End Function

' Rcupre la chaine de caractre aprs le " = " dans une chaine passe en paramtre
Function GetAfterEqual(ByVal psText As String) As String
Dim i As Integer
On Error GoTo ErrHandler
    
    i = InStr(1, psText, "=")
    GetAfterEqual = Right(psText, Len(psText) - i - 1)
    If GetAfterEqual = "NULL" Then
        GetAfterEqual = ""
    End If
    
  Exit Function
ErrHandler:
  Call ErrorHandler("GetAfterEqual")
End Function


' ***************************** CONFIG FUNCTIONS *************************************


' ************************************************************************************
' **************************** FRAMEWORK FUNCTIONS ***********************************
' ************************************************************************************

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

' Trace une opration quelconque dans la base (table Web_MailLog)
Private Sub AddToLog(ByVal psOperation As String, ByVal psID As String, Optional ByVal as_msgPrefix As String = vbTab)
Dim lsReq       As String   ' Contient la requte  passer au serveur

    Call UpdateError(True)  ' save error before 'On Error'
    
On Error GoTo ErrHandler
    txtLog.Text = Left(as_msgPrefix & psOperation & vbCrLf & txtLog.Text, C_LOGTXTMAX)
    
    lsReq = "INSERT INTO Web_MailLog SELECT '" & Replace(psOperation, "'", "''") & "', " & psID & ", GETDATE()"
    Call ExecuteSQLSafe(mo_Db, lsReq, 1)
    
    Call UpdateError(False)     ' restore error
    Exit Sub

ErrHandler:
    txtLog.Text = Left(vbTab & "Unable to create log. Err(" & Err.Number & "-" & Err.Description & ")" & vbCrLf & txtLog.Text, C_LOGTXTMAX)
    Call UpdateError(False)
    txtLog.Text = Left(vbTab & "Current error: " & Err.Number & "-" & Err.Description & vbCrLf & txtLog.Text, C_LOGTXTMAX)
End Sub


Private Sub AddToLogEx(ByVal psOperation As String, ByVal psID As String, Optional ByVal as_msgPrefix As String = vbTab & "DebugEx:")
Dim lsReq       As String   ' Contient la requte  passer au serveur

    Call UpdateError(True)  ' save error before 'On Error'
    
On Error GoTo ErrHandler
If ml_LogEX > 1 Then
    txtLog.Text = Left(as_msgPrefix & psOperation & vbCrLf & txtLog.Text, C_LOGTXTMAX)
End If

If ml_LogEX > 0 Then
    lsReq = "INSERT INTO Web_MailLog SELECT '" & Replace(psOperation, "'", "''") & "', " & psID & ", GETDATE()"
    Call ExecuteSQLSafe(mo_Db, lsReq, 1)
End If
    
    Call UpdateError(False)     ' restore error
    Exit Sub

ErrHandler:
    txtLog.Text = Left(vbTab & "Unable to create log. Err(" & Err.Number & "-" & Err.Description & ")" & vbCrLf & txtLog.Text, C_LOGTXTMAX)
    Call UpdateError(False)
    txtLog.Text = Left(vbTab & "Current error: " & Err.Number & "-" & Err.Description & vbCrLf & txtLog.Text, C_LOGTXTMAX)
End Sub
' Traite et demande l'envoi d'un mail s'il est  "N" ou "V"
Private Sub Generator(ByVal psID As String, ByVal psStatus As String)
Dim lsOperation             As String   ' Libll de l'opration en cours
Dim lsDestPeople            As String   ' Liste des personnes destinataires des mails
Dim lsDestID                As String   ' Liste des ID des personnes destinataires des mails
'Dim lsEMail                 As String   ' Adresse EMail du client
Dim lsTitle                 As Variant  ' Titre du message de rponse
Dim lsBody                  As Variant  ' Texte  envoyer au client
Dim lsPath                  As String   ' Chemin du fichier NSF a utiliser pour l'envoi du mail
Dim lsFrom                  As String   ' Adresse EMail de la personne qui a rpondu au mail
Dim lsPassword              As String   ' Mot de passe de la personne qui a rpondu au mail
Dim lsAR                    As String   ' 0: pas d'accus-rception, 1: avec accus-rception
Dim lsDestTo                As String   ' Liste des personnes destinataires directes des mails
Dim lsDestCopy              As String   ' Liste des personnes destinataires des mails par copie
Dim lsAttachment()          As String   ' Liste des fichiers  mettre en pice jointe
Dim lsMailType              As String   ' Type de mail  traiter
Dim lsKeyFilename           As String   ' Config du compte de messagerie  utiliser
Dim lsCertificateExpChecked As String
Dim lsMailFile              As String
Dim lsLocation              As String
Dim lsNewMailSeqNum         As String
Dim i                       As Integer


    On Error GoTo EndFunction
    
    Select Case psStatus
    Case "N"
        lsOperation = "One new mail found for Armstrong. Mail ID: " & psID
    Case "V"
        lsOperation = "One new mail found for Customer. Mail ID: " & psID
    End Select
    
    Call AddToLog(lsOperation, psID, Date & " " & Time & "  ")
    
    ReDim lsAttachment(0) As String
    
    lsMailType = GetMailType(psID)
    Select Case lsMailType
    
    Case "4" ' Si le mail est de type Binder
        ' Dfinie les paramtres pour l'envoi du mail du binder
        Call GetBinderParameters(psID, lsFrom, lsDestTo, lsDestCopy, lsTitle, lsBody, lsAttachment())
        
#If LIVE = 0 Then
    lsDestTo = "nagy@estimate.sk"
#End If
 
        ' Envoie le mail
        Call SendMail(psID, lsDestTo, lsDestCopy, msNotifPath, msNotifLogin, lsAttachment(), msNotifPassword, lsTitle, lsBody, msDefaultcharset, "0", msDefaultKeyFilename, msDefaultCertificateExpChecked, msDefaultMailFile, msDefaultLocation, msDefaultNewMailSeqNum, lsFrom, True, lsMailType, psStatus)
        ' Met  jour le status du mail  "T"
        Call UpdateRequest(psID, "T")
        Call AddToLog("Binder sent", psID)
    Case "5" ' Si le mail est de type Password
        ' Dfinie les paramtres pour l'envoi du mail de password
        Call GetPasswordParameters(psID, lsDestPeople, lsBody)
        
#If LIVE = 0 Then
    lsDestPeople = "nagy@estimate.sk"
#End If
        
        ' Envoie le mail
        Call SendMail(psID, lsDestPeople, "", msNotifPath, msNotifLogin, lsAttachment(), msNotifPassword, "", lsBody, msDefaultcharset, "0", msDefaultKeyFilename, msDefaultCertificateExpChecked, msDefaultMailFile, msDefaultLocation, msDefaultNewMailSeqNum, "", False, lsMailType, psStatus)
        ' Met  jour le status du mail  "T"
        Call UpdateRequest(psID, "T")
        Call AddToLog("New password sent", psID)
    
    Case Else ' Dans tous les autres cas
        Select Case psStatus
        Case "N" ' S'il s'agit d'un mail nouveau
            ' Dfinie les paramtres d'envoi du mail
            Call DefineDestArmstrong(psID)
            lsDestPeople = ""
            lsDestID = ""
            If UBound(msArmMail, 2) = 0 Then
                ml_OneUser = ml_OneUser + 1
                lbl_OneUser.Caption = "Mails sent to only one user : " & ml_OneUser
            End If
            For i = 0 To UBound(msArmMail, 2)
                lsDestPeople = lsDestPeople & msArmMail(0, i) & ", "
                lsDestID = lsDestID & msArmMail(2, i) & ", "
            Next i
            If lsDestPeople <> "" Then
                lsDestPeople = Left(lsDestPeople, Len(lsDestPeople) - 2)
            End If
            If lsDestID <> "" Then
                lsDestID = Left(lsDestID, Len(lsDestID) - 2)
            End If
            ' sauvegarde les donnes dans la base (liste des gens informs du mail)
            Call SaveArmstrongDest(psID, lsDestID)
            
            'mw 13.10.2008 >>
            If IsEmailBlackListed(psID) = True Then
                Call UpdateRequest(psID, "B")
                Call AddToLog("Email Blacklisted", psID)
            Else
                ' Envoie le mail
#If LIVE = 0 Then
    lsDestPeople = "nagy@estimate.sk"
#End If
                Call SendMail(psID, lsDestPeople, "", msNotifPath, msNotifLogin, lsAttachment(), msNotifPassword, msNotifTitle & " (" & psID & ")", GetNotifMessage(psID), msDefaultcharset, "0", msDefaultKeyFilename, msDefaultCertificateExpChecked, msDefaultMailFile, msDefaultLocation, msDefaultNewMailSeqNum, "", False, lsMailType, psStatus)
                Call UpdateRequest(psID, "I")
                Call AddToLog("Notification sent", psID)
            End If
            'mw <<
            
        Case "V" ' S'il s'agit d'une rponse  un mail
            ' Dfinie les paramtres du mail
            Call DefineResponseParam(psID, lsTitle, lsBody, msDefaultcharset, lsPath, lsFrom, lsPassword, lsAR, lsKeyFilename, lsCertificateExpChecked, lsMailFile, lsLocation, lsNewMailSeqNum, lsAttachment())
            lsDestTo = Join(msDestMailTo, ", ")
            lsDestCopy = Join(msDestMailCopy, ", ")
            
#If LIVE = 0 Then
    lsDestTo = "nagy@estimate.sk"
#End If
            ' Envoie le mail
            Call SendMail(psID, lsDestTo, lsDestCopy, lsPath, lsFrom, lsAttachment(), lsPassword, lsTitle, lsBody, msDefaultcharset, lsAR, lsKeyFilename, lsCertificateExpChecked, lsMailFile, lsLocation, lsNewMailSeqNum, "", False, lsMailType, psStatus)
            Call AddToLog("Mail sent", psID)
            Call UpdateRequest(psID, "T")
        End Select
    End Select
    Exit Sub

EndFunction:
    Call ErrorHandler(Extender.Name & ".Generator()")
End Sub

Private Function IsEmailBlackListed(ByVal psID As String)
On Error GoTo ErrHandler
Dim lsReq       As String
Dim ll_Cursor   As Long
    
    IsEmailBlackListed = False
      
    lsReq = "EXEC Web_MailBlackList_IsBlacklisted '" & psID & "'"
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    If mo_Db.RowCount(ll_Cursor) > 0 Then
        IsEmailBlackListed = True
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Exit Function
   
ErrHandler:

    Call AddToLog("Unable check if email is BlackListed", psID)   ' extra information log
    Call AddToLog(App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:UpdateRequest" & SEP1 & Err.Source & ", Err.Description " & Err.Description & ".", psID)
    
End Function

' Traite et demande l'envoi d'un mail s'il est  "S"
Private Sub GeneratorForward(ByVal psID As String)
Dim lsOperation             As String   ' Libll de l'opration en cours
Dim lsTitle                 As String   ' Titre du message de rponse
Dim lsBody                  As String   ' Texte  envoyer au client
Dim lsReq                   As String   ' Contient la requte  passer au serveur
Dim ll_Cursor               As Long
Dim lsAttachment()          As String   ' Liste des fichiers  mettre en pice jointe
Dim lsDestTo                As String   ' Liste des personnes destinataires directes des mails
Dim lsDestCopy              As String   ' Liste des personnes destinataires des mails par copie
Dim i                       As Integer

On Error GoTo ErrHandler
    
    lsOperation = "One new forward request found. Forward Mail ID: " & psID
    Call AddToLog(lsOperation, psID, Date & " " & Time & "  ")
    
    lsTitle = "Mail forwarded from the web site"
    
    lsReq = "SELECT CA.CA_Name 'CA_Name', MF.MF_Body 'MF_Body'" _
          & "  FROM Web_ContactArmstrong CA, Web_MailForward MF" _
          & "    WHERE CA.ID = MF.CA_ID" _
          & "      AND MF.MF_ID = " & psID
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    If Not mo_Db.EOF(ll_Cursor) Then
        lsBody = "Message forwarded by: " & mo_Db.GetFields(ll_Cursor, "CA_Name") & vbCrLf & vbCrLf _
               & "Comment: " & mo_Db.GetFields(ll_Cursor, "MF_Body") & vbCrLf & vbCrLf _
               & "Original Mail:" & vbCrLf & vbCrLf _
               & "Author inforamtion:" & vbCrLf & GetAuthorInfo(psID) & vbCrLf _
               & "Mail type and date of reception: " & GetMailMainInfo(psID) & vbCrLf _
               & "Customer message: " & vbCrLf & GetQuestionInfo(psID)
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ReDim lsAttachment(0) As String
    
    Call DefineForwardParam(psID, lsAttachment())
    lsDestTo = ""
    For i = 0 To UBound(msDestMailTo)
        lsDestTo = lsDestTo & msDestMailTo(i) & ", "
    Next i
    If lsDestTo <> "" Then
        lsDestTo = Left(lsDestTo, Len(lsDestTo) - 2)
    End If
    lsDestCopy = ""
    For i = 0 To UBound(msDestMailCopy)
        lsDestCopy = lsDestCopy & msDestMailCopy(i) & ", "
    Next i
    If lsDestCopy <> "" Then
        lsDestCopy = Left(lsDestCopy, Len(lsDestCopy) - 2)
    End If
    
    ' Envoie le mail
#If LIVE = 0 Then
    lsDestTo = "nagy@estimate.sk"
#End If
    
    Call SendMail(psID, lsDestTo, lsDestCopy, msNotifPath, msNotifLogin, lsAttachment(), msNotifPassword, lsTitle, lsBody, msDefaultcharset, "0", msDefaultKeyFilename, msDefaultCertificateExpChecked, msDefaultMailFile, msDefaultLocation, msDefaultNewMailSeqNum, "", False, "7", "S")
    lsOperation = "Mail forward sent"
    Call AddToLog(lsOperation, psID)
    Call UpdateForwardRequest(psID, "T")
    
    Exit Sub
ErrHandler:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If

    Call ErrorHandler(Extender.Name & ".GeneratorForward()")
End Sub

Private Function GetNotifMessage(ByVal psID As String) As String
On Error GoTo ErrHandler
Dim lsReq           As String   ' Contient la requte  passer au serveur
Dim ls_ret          As String
Dim ll_Cursor       As Long

    GetNotifMessage = ""
    ls_ret = msNotifMessage & vbCrLf & "ID: " & psID & vbCrLf & "Project: $PRF_ID16$" & vbCrLf & "Size: $PRF_ID15$"
    
    lsReq = "SELECT CP.CP_Value, CP.PRF_ID" _
            & " FROM Web_CUS_PRF CP" _
            & " INNER JOIN Web_Mail M ON M.CUS_ID = CP.CUS_ID" _
            & " WHERE CP.PRF_ID IN (15, 16)" _
            & " AND M.M_ID = " & psID _
            & " AND CP.Number = 1"
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    While Not mo_Db.EOF(ll_Cursor)
        ls_ret = Replace(ls_ret, "$PRF_ID" & mo_Db.GetFields(ll_Cursor, "PRF_ID") & "$", mo_Db.GetFields(ll_Cursor, "CP_Value"))
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ' replace if values were not provided
    ls_ret = Replace(ls_ret, "$PRF_ID15$", "Not defined")
    ls_ret = Replace(ls_ret, "$PRF_ID16$", "Not defined")
    
    GetNotifMessage = ls_ret
    Exit Function
ErrHandler:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".GetNotifMessage()")
End Function

' Rcupre les informations sur l'auteur du mail pass en paramtre
Private Function GetAuthorInfo(psID As String) As String
Dim lsReq           As String   ' Contient la requte  passer au serveur
Dim ll_Cursor       As Long
    
    On Error GoTo errGetAuthorInfo
    GetAuthorInfo = ""

    lsReq = "SELECT PRF.PRF_Desc 'Desc', CP.CP_Value 'Value', CP.PRF_ID 'ID'" _
            & " FROM Web_CUS_PRF CP" _
            & " INNER JOIN Web_Mail M ON M.CUS_ID = CP.CUS_ID" _
            & " INNER JOIN Web_MailForward MF ON MF.M_ID = M.M_ID AND MF.MF_ID = " & psID _
            & " INNER JOIN Web_Profile PRF ON PRF.PRF_ID = CP.PRF_ID" _
            & " WHERE CP.PRF_ID IN (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)" _
            & " AND CP.Number = 1" _
            & " ORDER BY CP.PRF_ID"
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    While Not mo_Db.EOF(ll_Cursor)
        GetAuthorInfo = GetAuthorInfo & mo_Db.GetFields(ll_Cursor, "Desc") & ": " & mo_Db.GetFields(ll_Cursor, "Value") & vbCrLf
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
 
    lsReq = "SELECT PRF.PRF_Desc 'Desc', CT.CT_Desc 'Value'" _
            & " FROM Web_CUS_PRF CP" _
            & " INNER JOIN Web_Mail M ON M.CUS_ID = CP.CUS_ID" _
            & " INNER JOIN Web_MailForward MF ON MF.M_ID = M.M_ID AND MF.MF_ID = " & psID _
            & " INNER JOIN Countries CT ON CT.CT_Code = CP.CP_Value AND CT.Language_Code = 'E'" _
            & " INNER JOIN Web_Profile PRF ON PRF.PRF_ID = CP.PRF_ID" _
            & " WHERE CP.PRF_ID = 17" _
            & " AND CP.Number = 1"
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    While Not mo_Db.EOF(ll_Cursor)
        GetAuthorInfo = GetAuthorInfo & mo_Db.GetFields(ll_Cursor, "Desc") & ": " & mo_Db.GetFields(ll_Cursor, "Value") & vbCrLf
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0

    lsReq = "SELECT PRF.PRF_Desc 'Desc', SMK.SMK_Desc 'Value'" _
            & " FROM Web_CUS_PRF CP" _
            & " INNER JOIN Web_Mail M ON M.CUS_ID = CP.CUS_ID" _
            & " INNER JOIN Web_MailForward MF ON MF.M_ID = M.M_ID AND MF.MF_ID = " & psID _
            & " INNER JOIN Sales_Markets SMK ON SMK.SMK_Code = CP.CP_Value AND SMK.Language_Code = 'E'" _
            & " INNER JOIN Web_Profile PRF ON PRF.PRF_ID = CP.PRF_ID" _
            & " WHERE CP.PRF_ID = 18" _
            & " AND CP.Number = 1"
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    While Not mo_Db.EOF(ll_Cursor)
        GetAuthorInfo = GetAuthorInfo & mo_Db.GetFields(ll_Cursor, "Desc") & ": " & mo_Db.GetFields(ll_Cursor, "Value") & vbCrLf
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Function
errGetAuthorInfo:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".GetAuthorInfo()")
End Function

' Rcupre les informations gnrales du mail
Private Function GetMailMainInfo(psID As String) As String
Dim lsReq           As String   ' Contient la requte  passer au serveur
Dim ll_Cursor       As Long

    On Error GoTo errGetMailMainInfo
    GetMailMainInfo = ""
    
    lsReq = "SELECT CONVERT(VARCHAR, M.M_Date, 103) + ' ' + CONVERT(VARCHAR, M.M_Date, 108) 'Date', MT.MT_Desc 'Type'" _
          & " FROM Web_Mail M, Web_MailType MT, Web_MailForward MF" _
          & " WHERE M.M_ID = MF.M_ID" _
          & " AND MT.MT_ID = M.MT_ID" _
          & " AND MF.MF_ID = " & psID
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    If Not mo_Db.EOF(ll_Cursor) Then
        GetMailMainInfo = mo_Db.GetFields(ll_Cursor, "Type") & ", " & mo_Db.GetFields(ll_Cursor, "Date") & vbCrLf
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Function
    
errGetMailMainInfo:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".GetMailMainInfo()")
End Function

' Rcupres les informations du mail envoy par le client
Private Function GetQuestionInfo(psID As String) As String
Dim lsReq           As String   ' Contient la requte  passer au serveur
Dim ll_Cursor       As Long

    On Error GoTo errGetQuestionInfo
    GetQuestionInfo = ""
    
    lsReq = "SELECT MC.MC_Value 'Body'" _
          & " FROM Web_MailComment MC" _
          & " WHERE MC.M_ID = (SELECT MF.M_ID FROM Web_MailForward MF WHERE MF.MF_ID = " & psID & ")"
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    If Not mo_Db.EOF(ll_Cursor) Then
        GetQuestionInfo = mo_Db.GetFields(ll_Cursor, "Body") & vbCrLf & vbCrLf
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    lsReq = "SELECT MO.MO_Value 'PJ'" _
          & " FROM Web_MailObject MO" _
          & " WHERE MO.M_ID = (SELECT MF.M_ID FROM Web_MailForward MF WHERE MF.MF_ID = " & psID & ")" _
          & " ORDER BY 1"
    
    GetQuestionInfo = GetQuestionInfo & "Documentation requested:" & vbCrLf
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    While Not mo_Db.EOF(ll_Cursor)
        GetQuestionInfo = GetQuestionInfo & mo_Db.GetFields(ll_Cursor, "PJ") & vbCrLf
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Function
    
errGetQuestionInfo:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".GetQuestionInfo()")
End Function

' Dfinie le type d'un mail dont l'ID est pass en paramtre
Private Function GetMailType(ByVal psID As String) As String
Dim lsReq       As String   ' Contient la requte  passer au serveur
Dim ll_Cursor   As Long

    On Error GoTo EndFunction
    
    ' Excution de la procdure stocke
    lsReq = "SELECT MT_ID FROM Web_Mail WHERE M_ID = " & psID
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ' Rcupration du rsultats
    If Not mo_Db.EOF(ll_Cursor) Then
        GetMailType = mo_Db.GetFields(ll_Cursor, "MT_ID")
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Function

EndFunction:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".GetMailType")
End Function

' Envoie un mail en utilisant la configuration passe en paramtre
Private Sub SendMail(ByVal psID As String, ByVal psDestPeopleTo As String, ByVal psDestPeopleCopy As String, ByVal psPath As String, ByVal psFrom As String, psAttachment() As String, ByVal psPassword As String, ByVal psSubject As Variant, ByVal psBody As Variant, ByVal pscharset As String, ByVal psAR As String, ByVal psKeyFilename As String, ByVal psCertificateExpChecked As String, ByVal psMailFile As String, ByVal psMailLocation As String, ByVal psNewMailSeqNum As String, ByVal psVisualFrom As String, ByVal IsDispatchAddress As Boolean, ByVal psMailType As String, ByVal psStatus As String)
Dim IdsMail         As Object   ' Objet mail
Dim i               As Integer
Dim j               As Long
Dim k               As Integer
Dim lsDest          As String   ' Destinataire du mail
Dim lsFileSource    As String   ' Fichier source (pour les pices jointes)
Dim lsFileDest      As String   ' Fichier destination (pour les pices jointes)
Dim lo_Mail         As ArmGraphMail
Dim lo_att          As ArmGraphMailAttachment
'Dim ls_Attachment() As String
Dim lb_Attach       As Boolean
Dim lsOperation     As String
    
Dim lbRetVal As Boolean

    On Error GoTo ErrHandler

    Call AddToLogEx("SendMail_begin:mo_Exchange.CloseDatabase", "0")
    mo_Exchange.CloseDatabase
    Call AddToLogEx("SendMail_begin:mo_Exchange.CloseDatabase:OK", "0")

    Call AddToLogEx("SendMail.mo_Exchange.OpenDatabase:" & psFrom & ", " & psMailFile, "0")
    If Not mo_Exchange.OpenDatabase(psMailLocation, psPassword) Then
        Call Err.Raise(CompFncFailed, "mo_Exchange.OpenDatabase", "Error during OpenDatabase when send mail")
    End If
    Call AddToLogEx("SendMail.mo_Exchange.OpenDatabase: returned TRUE", "0")
   
    Set lo_Mail = New ArmGraphMail
    Call lo_Mail.Load_A_COM
    
'    lo_Mail.SendFromLocation = psMailLocation
'    lo_Mail.SendAsAccount = psFrom
    
    If psVisualFrom <> "" Then
        psBody = psBody & "   " & psVisualFrom
    End If
    
    
    If IsDispatchAddress Then ' Si on doit envoyer le mail  l'emsemble des destinataires sparment
        lsDest = psDestPeopleTo
        Call AddToLogEx("case IsDispatchAddress: lsDest:" & lsDest, "0")
        If psDestPeopleCopy <> "" Then
            lsDest = lsDest & ", " & psDestPeopleCopy
        End If
        i = 1
        j = 1
        While j < Len(lsDest)
            If Mid(lsDest, j, 1) = "," Then
                i = i + 1
            End If
            j = j + 1
        Wend
        ' Pour chaque destinataire
        For j = 1 To i
            
            lo_Mail.Subject = psSubject
            lo_Mail.Body = psBody
            
            lo_Mail.SetTextAddrTo GetSingleParameter(lsDest, j, ",")
            
            ' Dfinie et copie les pices jointes sur le serveur FTP
            If psMailType = 4 Then
                Call AddToLogEx("MailType=4: lo_Mail.AddAttachment:" & psAttachment(0), "0")
                
                Set lo_att = New ArmGraphMailAttachment
                lo_att.Load_A_COM
                
                lo_att.Name = psAttachment(0)
                lo_att.LocalPath = psAttachment(0)          ' TODO generate name from path?
                lo_att.IsInline = False
                
                lbRetVal = lo_Mail.AddAttachment(lo_att)
                Call AddToLogEx("MailType=4: lo_Mail.AddAttachment: returned " & IIf(lbRetVal, "TRUE", "FALSE"), "0")
                
                Set lo_att = Nothing
                'lo_Mail.Attachments = psAttachment
            Else
                ' Dfinie et copie les pices jointes sur le serveur FTP
                If psStatus = "V" Or psStatus = "S" Then
                    'ReDim ls_Attachment(UBound(psAttachment, 2))
                    For k = 0 To UBound(psAttachment, 2)
                        If psAttachment(0, k) <> "" Then
                            lsFileSource = msMailAttachmentPath & "\" & psAttachment(0, k)
                            lsFileDest = msMailAttachmentPath & "\CurrentMail\" & psAttachment(1, k)
                            If Dir(lsFileDest) <> "" Then
                                Kill lsFileDest
                            End If
                          FileCopy lsFileSource, lsFileDest
                          'ls_Attachment(k) = lsFileDest
                          lb_Attach = True
                          Call AddToLogEx("lo_Mail.AddAttachment:" & lsFileDest, "0")
                          
                            Set lo_att = New ArmGraphMailAttachment
                            lo_att.Load_A_COM
                            
                            lo_att.Name = psAttachment(0, k)
                            lo_att.LocalPath = lsFileDest          ' TODO generate name from path?
                            lo_att.IsInline = False
                          
                          lbRetVal = lo_Mail.AddAttachment(lo_att)
                          Call AddToLogEx("lo_Mail.AddAttachment: returned " & IIf(lbRetVal, "TRUE", "FALSE"), "0")
                          
                          Set lo_att = Nothing
                        End If
                    Next
                    If lb_Attach Then
                        'lo_Mail.Attachments = ls_Attachment
                    End If
                End If
            End If
            
            Call AddToLogEx("mo_Exchange.SendMail", "0")
            If Not mo_Exchange.SendMail(lo_Mail) Then
                'TODO Manage error
                Call Err.Raise(CompFncFailed, "mo_Exchange.SendMail", "unable to send the mail")
            End If
            Call AddToLogEx("mo_Exchange.SendMail: returned TRUE", "0")
        Next j
    Else ' Si on doit envoyer le mail  l'emsemble des destinataires
        Call AddToLogEx("case NOT IsDispatchAddress: psDestPeopleTo:" & psDestPeopleTo, "0")
        lo_Mail.Subject = psSubject
        lo_Mail.Body = psBody

        
        lo_Mail.SetTextAddrTo psDestPeopleTo
        
        lo_Mail.SetTextAddrCc psDestPeopleCopy
        
        
        If psMailType = 4 Then
            Call AddToLogEx("MailType=4: lo_Mail.AddAttachment:" & psAttachment(0), "0")
    
            Set lo_att = New ArmGraphMailAttachment
            lo_att.Load_A_COM
            
            lo_att.Name = psAttachment(0)
            lo_att.LocalPath = psAttachment(0)          ' TODO generate name from path?
            lo_att.IsInline = False
                            
            lbRetVal = lo_Mail.AddAttachment(lo_att)
            Call AddToLogEx("MailType=4: lo_Mail.AddAttachment: returned " & IIf(lbRetVal, "TRUE", "FALSE"), "0")
            
            Set lo_att = Nothing
            'lo_Mail.Attachments = psAttachment
        Else
            ' Dfinie et copie les pices jointes sur le serveur FTP
            If psStatus = "V" Or psStatus = "S" Then
                'ReDim ls_Attachment(UBound(psAttachment, 2))
                For k = 0 To UBound(psAttachment, 2)
                    If psAttachment(0, k) <> "" Then
                        lsFileSource = msMailAttachmentPath & "\" & psAttachment(0, k)
                        lsFileDest = msMailAttachmentPath & "\CurrentMail\" & psAttachment(1, k)
                        If Dir(lsFileDest) <> "" Then
                            Kill lsFileDest
                        End If
                        If mo_FSO.FileExists(lsFileSource) Then
                            Call mo_FSO.CopyFile(lsFileSource, lsFileDest)
                            
                            Set lo_att = New ArmGraphMailAttachment
                            lo_att.Load_A_COM
                            
                            lo_att.Name = psAttachment(1, k)
                            lo_att.LocalPath = lsFileDest          ' TODO generate name from path?
                            lo_att.IsInline = False
                            
                            'ls_Attachment(k) = lsFileDest
                            Call AddToLogEx("lo_Mail.AddAttachment:" & lsFileDest, "0")
                            lbRetVal = lo_Mail.AddAttachment(lo_att)
                            Call AddToLogEx("lo_Mail.AddAttachment: returned " & IIf(lbRetVal, "TRUE", "FALSE"), "0")
                            
                            Set lo_att = Nothing
                            lb_Attach = True
                        End If
                    End If
                Next
                If lb_Attach Then
                    'lo_Mail.Attachments = ls_Attachment
                End If
            End If
        End If
        
        Call AddToLogEx("mo_Exchange.SendMail", "0")
        If Not mo_Exchange.SendMail(lo_Mail) Then
            Call Err.Raise(CompFncFailed, "mo_Exchange.SendMail", "unable to send the mail")
        End If
        Call AddToLogEx("mo_Exchange.SendMail: returned TRUE", "0")
        
    End If
    
    Call AddToLogEx("end:mo_Exchange.CloseDatabase", "0")
    mo_Exchange.CloseDatabase
    Call AddToLogEx("end:mo_Exchange.CloseDatabase:OK", "0")
    Call lo_Mail.Unload_A_COM
    Set lo_Mail = Nothing
    
    Exit Sub
    
ErrHandler:
    Call UpdateError(True)
    If Not mo_Exchange Is Nothing Then
        Call AddToLogEx("error:mo_Exchange.CloseDatabase", "0")
        mo_Exchange.CloseDatabase
        Call AddToLogEx("error:mo_Exchange.CloseDatabase:OK", "0")
    End If
    Set lo_Mail = Nothing

    Call UpdateRequest(psID, "F")
    Call UpdateError(False)
    Call AddToLog("Unable to send the mail", psID)  ' extra info
    Call ErrorHandler(Extender.Name & ".SendMail")
End Sub


' Dfinie la liste des messageries  scruter
Private Sub DefineMailBoxes()
Dim sSQL        As String   ' Contient la requte  passer au serveur
Dim ll_Cursor   As Long     ' Recordset contenant le rsultat final
Dim i           As Integer
Dim ld_MailBoxInfo As Dictionary 'required by ArmExchange

On Error GoTo ErrHandler
    
    ' Excution de la procdure stocke
    sSQL = "SELECT SMK.SMK_Code 'Code', ISNULL(SMK.SMK_Path, '') 'Path'," _
         & " ISNULL(SMK.SMK_Name, '') 'Name', ISNULL(SMK.SMK_Password, '') 'Password'," _
         & " ISNULL(SMK.SMK_KeyFilename, '') 'Key', ISNULL(SMK.SMK_CertificateExpChecked, '') 'Certif'," _
         & " ISNULL(SMK.SMK_MailFile, '') 'File', ISNULL(SMK.SMK_Location, '') 'Location'," _
         & " ISNULL(SMK.SMK_NewMailSeqNum, '') 'SeqNum' " _
         & " FROM Web_SalesMarketsMail SMK WHERE drop_flag='N'"
    i = 0
    ll_Cursor = OpenSQLSafe(mo_Db, sSQL)
    ReDim msMailBox(8, mo_Db.RowCount(ll_Cursor) - 1) As String
    
    Set ld_MailBoxInfo = New Dictionary

    ' Rcupration du premier lment trouv
    While Not mo_Db.EOF(ll_Cursor)
'        ReDim Preserve msMailBox(8, i) As String
        msMailBox(0, i) = mo_Db.GetFields(ll_Cursor, "Code")
        msMailBox(1, i) = mo_Db.GetFields(ll_Cursor, "Path")
        msMailBox(2, i) = mo_Db.GetFields(ll_Cursor, "Name")
        msMailBox(3, i) = mo_Db.GetFields(ll_Cursor, "Password")
        msMailBox(4, i) = mo_Db.GetFields(ll_Cursor, "Key")
        msMailBox(5, i) = mo_Db.GetFields(ll_Cursor, "Certif")
        msMailBox(6, i) = mo_Db.GetFields(ll_Cursor, "File")
        msMailBox(7, i) = mo_Db.GetFields(ll_Cursor, "Location")
        msMailBox(8, i) = mo_Db.GetFields(ll_Cursor, "SeqNum")
        
        If msMailBox(6, i) <> "" Then
            If ld_MailBoxInfo.Exists(msMailBox(6, i)) = False Then
                Call ld_MailBoxInfo.Add(msMailBox(6, i), msMailBox(7, i))
            End If
        End If

        i = i + 1
        Call mo_Db.Next(ll_Cursor)
    Wend
    
    'mo_Exchange.MailBoxFolderInfo = ld_MailBoxInfo

    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
        
    Exit Sub

ErrHandler:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler(Extender.Name & ".DefineMailBoxes")
End Sub

' Rcupre un paraltre dans une chaine de caractre avec un certain dlimiteur et  un index donn
Private Function GetSingleParameter(ByVal psText As String, ByVal piIndex As Integer, ByVal psDelimiter As String) As String
Dim i As Integer
Dim j As Integer
Dim k As Integer
Dim l As Integer
On Error GoTo ErrHandler

    i = 1
    l = 1
    For j = 1 To piIndex
        k = InStr(l, psText, psDelimiter)
        i = l
        l = k + 1
    Next j
    If k = 0 Then
        k = Len(psText) + 1
    End If
    If piIndex <> 1 Then
        i = i + 1
    End If
    GetSingleParameter = Trim(Mid(psText, i, k - i))
    Exit Function

ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetSingleParameter")
End Function

' Scrute une messagerie pour voir si de nouveaux mails directs sont arrivs
Private Sub CheckMailBox()

Dim liNbMsg          As Long     ' Nombre de nouveaux messages
Dim lsReq            As String   ' Contient la requte  passer au serveur
Dim lsSMK            As String   ' Code du sales market destinataire du mail
Dim lsTo             As String   ' Liste des personnes en destination des mails
Dim lsCC             As String   ' Liste des personnes en copie des mails
Dim lsDelimiter      As String   ' Caractre qui sert de dlimiteur entre les adresses E-Mail
Dim lsFrom           As String   ' Adresse E-Mail de l'expditeur
Dim lsDest           As String   ' Liste des personnes qui ont reu le mail
Dim lsMessage        As Variant   ' Contenu du mail
Dim lsMessage1       As Variant
Dim lsMessageUnicode As String

Dim lv_IncomingPath As Variant   ' Chemin ou on sauvegarde les pices jointes
Dim lsID            As String   ' ID du mail enregistr
Dim ls_IMT_ID       As String   ' template ID
Dim i               As Long
Dim j               As Long
Dim la_message()    As Byte
Dim ll_Handle       As Long
Dim lsOperation     As String
Dim ll_Cursor       As Long
Dim lb_processed    As Boolean
Dim lo_folder       As Object
Dim lo_File         As Object
Dim ls_leaveAttached As String  ' indicate if parsed xml file should be part of attachement of mail
Dim ls_SafeFileName As String

Dim lbRetVal As Boolean

Dim lo_InboxFolder As ArmGraphMailbox

On Error GoTo ErrHandler
    
    mb_DirectMailFound = False

    lbl_Task = "Actual task: Scanning Exchange Database " & msMailBox(6, miMailIndex)
    'Debug.Assert msMailBox(6, miMailIndex) <> "mail\qcis"
         
    ' Open the database
    Call AddToLogEx("mo_Exchange.OpenDatabase:" & msMailBox(2, miMailIndex) & ", " & msMailBox(6, miMailIndex), "0")
    If Not mo_Exchange.OpenDatabase(msMailBox(7, miMailIndex), msMailBox(3, miMailIndex)) Then
        'error during open database.
        lsOperation = "Error during OpenDatabase : " & msMailBox(7, miMailIndex) & "," & msMailBox(2, miMailIndex) & "," & msMailBox(3, miMailIndex)
        Call AddToLog(lsOperation, "0")
        Call Err.Raise(ArmErr.CompFncFailed, "mo_Exchange.OpenDatabase", lsOperation)
    End If
    Call AddToLogEx("mo_Exchange.OpenDatabase:returned TRUE", "0")
    
    Set lo_InboxFolder = mo_Exchange.GetMailboxFolder("Inbox")
    
    ' Get the count of document
    Call AddToLogEx("mo_Exchange.GetMailCount:" & "Inbox", "0")
    liNbMsg = mo_Exchange.GetMailCount()
    Call AddToLogEx("mo_Exchange.GetMailCount returned:" & liNbMsg, "0")
    
    Dim lo_Mail As ArmGraphMail
    Dim lv_AttachedName As Variant, ll_Index As Long
    
    lsDelimiter = ","
    
    ' Pour chaque nouveau mail
    For i = 0 To liNbMsg - 1
        Set lo_Mail = lo_InboxFolder.GetMail(i)
        ' Charge le message
        Call AddToLogEx("mo_Exchange.ReadMail:" & "($INBOX)" & " Nb:" & i, "0")
        lb_processed = False
        'todo
        If Not mo_Exchange.ReadMail(lo_Mail) Then
          'error during open database.
          lsOperation = "Error during ReadMail : " & msMailBox(7, miMailIndex) & "," & msMailBox(6, miMailIndex) & "," & msMailBox(3, miMailIndex)
          Call AddToLog(lsOperation, "0")
          Call Err.Raise(ArmErr.CompFncFailed, "mo_Exchange.ReadMail", lsOperation)
        Else
            Call AddToLogEx("mo_Exchange.ReadMail:returned OK", "0")
            Debug.Assert (mo_Db.CursorCount = 0)
            ' Extrait les pices jointes
            lv_IncomingPath = msMailAttachmentPath & "\IncomingMail"
            If Not mo_FSO.FolderExists(lv_IncomingPath) Then
                Call AddToLog("Folder for incomming mail attachement does not exists. (" & lv_IncomingPath & ")", "0")
                Exit For
            End If
            
            Set lo_folder = mo_FSO.GetFolder(lv_IncomingPath)
            Call mo_FSO.DeleteFile(lv_IncomingPath & "\*.*", True)
            
            For ll_Index = 1 To lo_Mail.Attachments.Count
                Call AddToLogEx("Start to process attachement Nb:" & ll_Index, "0")
                lv_AttachedName = lo_Mail.Attachments(ll_Index).Name
                Call AddToLogEx("Orig name:" & lv_AttachedName, "0")
                'todo
                'Text1.Text = ConvertCodePageFromUnicode(lv_IncomingPath & "\" & lv_AttachedName, 1251)
                Dim l1 As Integer
                For l1 = 1 To Len(lv_AttachedName)
                   ls_SafeFileName = ls_SafeFileName + Chr(Asc(Mid(lv_AttachedName, l1, 1)))
                Next
                
                 If (InStr(1, ls_SafeFileName, "?") > 0) Then
                    If Len(ConvertCodePageFromUnicode(lv_AttachedName, 1251)) > 0 Then
                        ls_SafeFileName = ConvertCodePageFromUnicode(lv_AttachedName, 1251)
                    Else
                        ls_SafeFileName = ConvertCodePageFromUnicode(lv_AttachedName, 1250)
                    End If
                 Else
                    ls_SafeFileName = lv_AttachedName
                 End If
                ls_SafeFileName = Replace(ls_SafeFileName, "?", "_")    ' 24.1.2007 bug337 JN - non unicode russian attachement
 '               ls_SafeFileName = Replace(ls_SafeFileName, ":", "_")    ' 19.12.2019 JN - attachement with ":" in name
                 
                Call AddToLogEx("lo_Mail.GetAttachment:" & lv_AttachedName & " to:" & lv_IncomingPath & "\" & ls_SafeFileName, "0")
                lbRetVal = lo_Mail.Attachments(ll_Index).Save(lv_IncomingPath & "\" & ls_SafeFileName)
                Call AddToLogEx("lo_Mail.GetAttachment: returned " & IIf(lbRetVal, "TRUE", "FALSE"), "0")
                If Not lbRetVal Then
                    Call AddToLog("lo_Mail.GetAttachment: returned Error" & ArmREST.ms_Exception, "0")
                End If
                
            Next
  
            lsTo = lo_Mail.GetTextAddrTo
            lsCC = lo_Mail.GetTextAddrCc
            lsSMK = msMailBox(0, miMailIndex) 'DefineSalesMarket(lsTo, lsCC, lsDelimiter) ' TODO : check the delimiter with martin
            lsFrom = lo_Mail.GetTextAddrFrom
            
            lsFrom = ExtractEMailAddress(lsFrom)
            ' bug with emails without sender 28.4.2011 JN
            If Trim(lsFrom) = "" Then lsFrom = C_UNKNOWN_SENDER
            
            
            ' yes it is mail from addres that has defined template
            ls_leaveAttached = ""
            ls_IMT_ID = GetTemplateIDFromAddress(lsFrom, ls_leaveAttached)
            If ls_IMT_ID <> "" And lo_Mail.Attachments.Count > 0 Then
                ' set default placeholders
                Call setPlaceholderVal("CHARSET", msDefaultcharset)
                Call setPlaceholderVal("FROM", lsFrom)
                Call setPlaceholderVal("COPY", lsDest)
                Call setPlaceholderVal("SMK", lsSMK)
                Call setPlaceholderVal("BODY", lo_Mail.Body)
                Call setPlaceholderVal("SUBJECT", lo_Mail.Subject)
                Call setPlaceholderVal("STATUS", GetStatusForNewMail(lo_Mail.Subject))  ' task 376 JN 2.3.2007
                Call setPlaceholderVal("Web_Mail.M_ID", Empty)
                
                ' process all xml attachments
                j = 0
                For Each lo_File In lo_folder.Files
                    If lo_File.Name Like "*.xml" Then
                        Call AddToLogEx("ParseXML:" & ls_IMT_ID & ", " & lo_File.Path, "0")
                        If ParseXML(ls_IMT_ID, lo_File.Path) Then
                            If Not IsEmpty(getPlaceholderVal("Web_Mail.M_ID")) Then
                                lsID = getPlaceholderVal("Web_Mail.M_ID")
                                If ls_leaveAttached = "Y" Then
                                    lsReq = "INSERT INTO Web_MailAttachment" _
                                          & " SELECT " & lsID & ", 'C" & lsID & "-" & j & "', '" & DoubleQuote(lo_File.Name) & "', GETDATE(), GETDATE(), 'sa', 1, 'X', 'N', NULL"
                                    Call ExecuteSQLSafe(mo_Db, lsReq)
                                End If
                                Call AddToLogEx("Parsed loop:lo_File.Move:" & msMailAttachmentPath & "\C" & lsID & "-" & j, lsID)
                                Call lo_File.Move(msMailAttachmentPath & "\C" & lsID & "-" & j)
                            Else
                                Call lo_File.Delete(True)
                            End If
                            j = j + 1
                        Else
                            ' cannot insert attachement
                            Call AddToLog("Attachement cannot be inserted into DB.( Mail is not available. )", "0", vbTab & "Warning:")
                        End If
                    End If
                    
                Next
                If j <> 1 Then
                  ' this part of program expects just one attachement
                    Call AddToLog("One *.XML attachement expected, but found:" & j, "0", vbTab & "Warning:")
                End If
                Call TestInsertedData
            
                ' put other files into attachement
                If Not IsEmpty(getPlaceholderVal("Web_Mail.M_ID")) Then
                    lsID = getPlaceholderVal("Web_Mail.M_ID")
                    For Each lo_File In lo_folder.Files
                        lsReq = "INSERT INTO Web_MailAttachment" _
                              & " SELECT " & lsID & ", 'C" & lsID & "-" & j & "', '" & DoubleQuote(lo_File.Name) & "', GETDATE(), GETDATE(), 'sa', 1, 'X', 'N', NULL"
                        Call ExecuteSQLSafe(mo_Db, lsReq)
                        Call AddToLogEx("Not Parsed loop:lo_File.Move:" & msMailAttachmentPath & "\C" & lsID & "-" & j, lsID)
                        Call lo_File.Move(msMailAttachmentPath & "\C" & lsID & "-" & j)
                        j = j + 1
                    Next
                    lb_processed = True
                Else
                    ' cannot insert attachement process mail as direct mail
                    Call AddToLog("Trying to process as Direct mail.", "0", vbTab & "Warning:")
                End If
            End If
            
            If Not lb_processed Then
              ' Si l'expditeur du mail n'est pas connu d'Armstrong
              If Not (IsArmstrongAddress(lsFrom)) Then
                  
                  lsDest = lsTo
                  If lsCC <> "" Then
                      lsDest = lsDest & lsDelimiter & " " & lsCC
                  End If
                  
                  ' Rcupre le code du message
                  lsMessage = ""
                  
                  If lo_Mail.Subject <> "" Then
                      lsMessage = lo_Mail.Subject & vbCrLf & vbCrLf
                  End If
                  
                  If lo_Mail.Body <> "" Then
                      lsMessage = lsMessage & lo_Mail.Body
                  End If
            
                  txtLog.Text = Left("One mail found from " & lsFrom & " on " & msMailBox(6, miMailIndex) & vbCrLf & txtLog.Text, C_LOGTXTMAX)
                  mb_DirectMailFound = True
              
                  ' task 376 m_status parameter to SP, JN 2.3.2007
                  ' Insre dans la base le nouveau mail trouv
                  lsReq = "EXEC Web_Mail_Ins '" & msDefaultcharset & "', '" _
                       & DoubleQuote(lsFrom) & "', '" & lsSMK & "', '" _
                       & DoubleQuote(lsDest) & "', '" & GetStatusForNewMail(lo_Mail.Subject) & "'"
                  ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
                  If Not mo_Db.EOF(ll_Cursor) Then
                      lsID = mo_Db.GetFields(ll_Cursor, "ID")
                  End If
                  Call mo_Db.Close(ll_Cursor)
                  ll_Cursor = 0
                  'cut first 3950 characters to avoid error when inserting into database
                  lsMessage = DoubleQuote(Left(lsMessage, 3950))
                  ' Insre en plusieurs fois le contenu texte du mail
                  
                  ' TODO : Manage un champs NText
                  lsReq = "INSERT INTO Web_MailComment" _
                           & " SELECT " & lsID & ", 6, N'" & lsMessage & "', GETDATE(), GETDATE(), 'sa', 1, 'X', 'N', NULL"
                  Call ExecuteSQLSafe(mo_Db, lsReq)
                  
                  ' Enregistre les pices jointes sur le serveur FTP et les trace dans la base
                  j = 0
                  ' 24.1.2007 bug337 JN
                  For Each lo_File In lo_folder.Files
                    lsReq = "INSERT INTO Web_MailAttachment" _
                          & " SELECT " & lsID & ", 'C" & lsID & "-" & j & "', '" & DoubleQuote(lo_File.Name) & "', GETDATE(), GETDATE(), 'sa', 1, 'X', 'N', NULL"
                    Call ExecuteSQLSafe(mo_Db, lsReq)
                    Call AddToLogEx("Standard loop:lo_File.Move:" & msMailAttachmentPath & "\C" & lsID & "-" & j, lsID)
                    Call lo_File.Move(msMailAttachmentPath & "\C" & lsID & "-" & j)
                    j = j + 1
                  Next
                  lb_processed = True
              End If
            End If
            
            If Not lb_processed Then
                Call AddToLog("One unprocessed mail in mailbox.", "0", vbTab & "Warning:")
            End If
            
            'mw 26.04.2011 >>
            Call AddToLogEx("mo_Exchange.MoveMail(""Processed"")", "0")
            If Not mo_Exchange.MoveMail(lo_Mail, "Processed") Then
  
                lsOperation = "unable to move the mail in the folder 'processed'"
                txtLog.Text = Left(" " & lsOperation & vbCrLf & txtLog.Text, C_LOGTXTMAX)
            Else
                Call AddToLogEx("mo_Exchange.MoveMail: returned TRUE", "0")
            End If
          lo_Mail.Unload_A_COM
          Set lo_Mail = Nothing
        End If
    Next i

    Call AddToLogEx("mo_Exchange.CloseDatabase", "0")
    mo_Exchange.CloseDatabase
    Call AddToLogEx("mo_Exchange.CloseDatabase: OK", "0")
    
    
    ' Change la valeur de miMailIndex pour qu'au prochain passage
    ' ce soit une autre messagerie qui soit scrute
    miMailIndex = miMailIndex + 1
    If miMailIndex > miMailMaxIndex Then
        miMailIndex = 0
    End If
    Exit Sub
    
ErrHandler:
    ' Libre les objets et change la valeur de miMailIndex pour qu'au prochain passage
    ' ce soit une autre messagerie qui soit scrute
   
    Set lo_Mail = Nothing
    mo_Exchange.CloseDatabase
    
    
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    If Err.Number <> 0 Then
        lsOperation = "Error during database processing: " & msMailBox(7, miMailIndex) & "," & msMailBox(6, miMailIndex) & "," & msMailBox(3, miMailIndex) & ", the error is " & Err.Number & " (" & Err.Description & ")"
        Call AddToLog(lsOperation, "0")
    End If

    
    miMailIndex = miMailIndex + 1
    If miMailIndex > miMailMaxIndex Then
        miMailIndex = 0
    End If
    
    Call ErrorMessage(Extender.Name & ".CheckMailBox", False)
    
End Sub

' do some extra check after template is created
Private Sub TestInsertedData()
On Error GoTo ErrHandler
    If IsEmpty(getPlaceholderVal("Web_Mail.M_ID")) Then
        Call AddToLog("Web_Mail record not inserted from template.", "0", vbTab & "Warning:")
    End If
    
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".TestInsertedData")
End Sub

Private Function GetTemplateIDFromAddress(ByVal as_address As String, ByRef as_leaveAttached As String) As String
On Error GoTo ErrHandler
Const REQ As String = "SELECT WMIA.IMT_ID, WMIA.leaveAttached FROM WM_IncomingAddress WMIA WHERE '$ADDR$' like WMIA.Incoming_Address"
    
    Dim ls_req      As String
    Dim ll_Cursor   As Long
    
    GetTemplateIDFromAddress = ""
    
    ls_req = Replace(REQ, "$ADDR$", SqlStr(as_address))         ' bug 360 JN 22.1.2007
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    If Not mo_Db.EOF(ll_Cursor) Then
        GetTemplateIDFromAddress = mo_Db.GetFields(ll_Cursor, "IMT_ID")
        as_leaveAttached = mo_Db.GetFields(ll_Cursor, "leaveAttached")
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Function
    
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".GetTemplateIDFromAddress")
End Function

' Dfinie si une adresse e-mail est celle d'un sales market ou non
Private Function IsArmstrongAddress(ByVal psAddress As String) As Boolean
Dim lsReq           As String   ' Contient la requte  passer au serveur
Dim ll_Cursor       As Long

On Error GoTo ErrHandler
    IsArmstrongAddress = False
    
    lsReq = "SELECT COUNT(*) 'Count'" _
          & " FROM Web_SalesMarketsMail" _
          & " WHERE SMK_Name = '" & DoubleQuote(psAddress) & "' and drop_flag='N'"

    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    If Not mo_Db.EOF(ll_Cursor) Then
        If Val(mo_Db.GetFields(ll_Cursor, "Count")) > 0 Then
            IsArmstrongAddress = True
        End If
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Function
    
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
        
    Call ErrorHandler(Extender.Name & ".IsArmstrongAddress")
End Function


' Extrait l'adresse e-mail d'une chaine de caractre contenant le nom et l'adresse de l'expditeur
Private Function ExtractEMailAddress(ByVal psAddress As String) As String
Dim i As Integer
On Error GoTo ErrHandler

    i = InStr(1, psAddress, "<")
    If i <> 0 Then
        psAddress = Right(psAddress, Len(psAddress) - i)
    End If
    
    i = InStr(1, psAddress, ">")
    If i <> 0 Then
        psAddress = Left(psAddress, i - 1)
    End If
    
    ExtractEMailAddress = psAddress
        
    Exit Function
    
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ExtractEMailAddress")
End Function

' Rcupre le code du sales market en fonction des adresses e-mail en To ou Copy
Private Function DefineSalesMarket(ByVal psTo As String, ByVal psCC As String, ByVal psDelimiter As String) As String
Dim lsReq           As String   ' Contient la requte  passer au serveur
Dim lsDest          As String   ' Liste des adresses E-Mail destinataires (To ou CC)
Dim liNbElements    As Integer  ' Nombre de personnes destinataires
Dim lsEMail         As String   ' Adresse E-Mail du destinataire
Dim i               As Long
Dim lsFullName      As String
Dim lsName          As String
Dim lsSurName       As String
Dim liSeparator     As Integer
Dim lsSeparator     As String
Dim liPos1          As Integer
Dim liPos2          As Integer
Dim ll_Cursor       As Long

On Error GoTo ErrHandler
    
    ' Concatne les chaines To et Copy
    lsDest = psTo
    If psCC <> "" Then
        lsDest = lsDest & psDelimiter & " " & psCC
    End If
    
    ' Compte le nombre d'adresses e-mail
    i = 1
    liNbElements = 1
    While i < Len(lsDest)
        If Mid(lsDest, i, 1) = psDelimiter Then
            liNbElements = liNbElements + 1
        End If
        i = i + 1
    Wend
    
    ' Rcupre le code du sales market
    For i = 1 To liNbElements
        lsEMail = GetSingleParameter(lsDest, i, psDelimiter)
    
        lsFullName = lsEMail
        
        liPos1 = InStr(1, lsFullName, "<")
        liPos2 = InStr(1, lsFullName, ">")
        If liPos1 > 0 Then
            lsFullName = Mid(lsFullName, liPos1 + 1, liPos2 - liPos1 - 1)
        End If
    
        lsSeparator = "/"
        liSeparator = InStr(1, lsFullName, lsSeparator)
        If liSeparator = 0 Then
            lsSeparator = "@"
            liSeparator = InStr(1, lsFullName, lsSeparator)
        End If
    
        If liSeparator <> 0 Then
            lsFullName = Left(lsFullName, liSeparator - 1)
        End If
        
        lsFullName = Replace(lsFullName, "_", " ")
        lsFullName = Replace(lsFullName, ".", " ")
        lsFullName = Replace(lsFullName, "-", " ")
    
        lsReq = "SELECT SMK_Code" _
             & " FROM Web_SalesMarketAddress" _
             & " WHERE EMail like '%" & DoubleQuote(lsFullName) & "%'"
        ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
        If Not mo_Db.EOF(ll_Cursor) Then
            DefineSalesMarket = mo_Db.GetFields(ll_Cursor, "SMK_Code")
            Call mo_Db.Close(ll_Cursor)
            ll_Cursor = 0
            Exit For
        End If
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    Next i
    
    Exit Function
    
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".DefineSalesMarket")
End Function

' Double les quotes d'une chaine de caractres afin de la rendre utilisable par SQL
Public Function DoubleQuote(psString As Variant) As Variant
On Error GoTo ErrHandler
Dim i As Long
Dim lsChar As String

    DoubleQuote = ""
    For i = 1 To Len(psString)
        lsChar = Mid(psString, i, 1)
        DoubleQuote = DoubleQuote & lsChar
        If lsChar = "'" Then
            DoubleQuote = DoubleQuote & lsChar
        End If
    Next i
    
    Exit Function

ErrHandler:
    Call ErrorHandler(Extender.Name & ".DoubleQuote")
End Function

' Rcupre l'ID du premier nouveau mail ou nouvelle rponse trouv dans la base
Private Function GetRequest(ByRef psID As String, ByRef psStatus As String) As Boolean
On Error GoTo ErrHandler
Dim lsReq       As String   ' Contient la requte  passer au serveur
Dim ll_Cursor   As Long

    GetRequest = False
    
    ' Excution de la procdure stocke
    lsReq = "SELECT TOP 1 M_ID, M_Status FROM Web_Mail WHERE M_Status IN ('N', 'V', 'S') and Drop_Flag='N' ORDER BY iConcurrency"     ' JN 13/1/2014 to not block the processign by failed emails
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ' Rcupration du premier lment trouv
    If Not mo_Db.EOF(ll_Cursor) Then
        psID = mo_Db.GetFields(ll_Cursor, "M_ID")
        psStatus = mo_Db.GetFields(ll_Cursor, "M_Status")
        GetRequest = True
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Function

ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".GetRequest")

End Function

' Rcupre la liste des ID des mails  forwarder
Private Sub GetForwardList(ByVal psID As String, ByRef psArray() As String)
Dim lsReq       As String   ' Contient la requte  passer au serveur
Dim ll_Cursor   As Long
Dim i           As Integer

    On Error GoTo EndFunction
    
    ' Excution de la procdure stocke
    lsReq = "SELECT MF_ID FROM Web_MailForward WHERE M_ID = " & psID & " AND MF_Status = 'N'"

    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ReDim psArray(-1 To -1) As String
    i = 0
    
    ' Rcupration des ID
    While Not mo_Db.EOF(ll_Cursor)
        If UBound(psArray) = -1 Then
            ReDim psArray(0)
        Else
            ReDim Preserve psArray(i) As String
        End If
        psArray(i) = mo_Db.GetFields(ll_Cursor, "MF_ID")
        i = i + 1
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Sub

EndFunction:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".GetForwardList")
End Sub

Private Sub UpdateIconc(ByVal psID As String)
On Error GoTo ErrHandler
    Dim lsReq       As String
    lsReq = "UPDATE Web_Mail SET iConcurrency = iConcurrency+1 WHERE M_ID = " & psID
    
    Call ExecuteSQLSafe(mo_Db, lsReq)
    Exit Sub
ErrHandler:
        Call ErrorHandler(Extender.Name & ".UpdateIconc")
End Sub


' this will propagate error via exception if psStatus <> "F" ... failed? - in this case function is called from error handler
Private Sub UpdateRequest(ByVal psID As String, ByVal psStatus As String)
On Error GoTo ErrHandler
Dim lsReq       As String   ' Contient la requte  passer au serveur
    
    ' Excution de la procdure stocke
    lsReq = "UPDATE Web_Mail SET M_Status = '" & psStatus & "' WHERE M_ID = " & psID
    
    Call ExecuteSQLSafe(mo_Db, lsReq)
    
    Exit Sub
   
ErrHandler:


    Call AddToLog("Unable to update the mail status to " & psStatus, psID)   ' extra information log
    If psStatus <> "F" Then
        Call ErrorHandler(Extender.Name & ".UpdateRequest")
    Else
        ' in this case we will not propagate error to upper level, just log information
        Call AddToLog(App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:UpdateRequest" & SEP1 & Err.Source & ", Err.Description " & Err.Description & ".", psID)
    End If
End Sub

' Dfinie les paramtres pour l'envoi d'un mail de type password
Private Sub GetPasswordParameters(ByVal psID As String, ByRef psEMail As String, ByRef psText As Variant)
On Error GoTo ErrHandler
Dim lsReq       As String   ' Contient la requte  passer au serveur
Dim ll_Cursor   As Long

    
    ' Requte pour rcuprer le destinataire du mail
    lsReq = "SELECT CP.CP_Value 'Address'" _
          & " FROM Web_CUS_PRF CP, Web_Mail M" _
          & " WHERE M.M_ID = " & psID _
          & "   AND CP.CUS_ID = M.CUS_ID" _
          & "   AND CP.PRF_ID = 3" _
          & "   AND CP.Number = 1"

    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    ' Rcupration de l'adresse trouve
    If Not mo_Db.EOF(ll_Cursor) Then
        psEMail = mo_Db.GetFields(ll_Cursor, "Address")
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0

    ' Requte pour la rcupration du corps du message
    lsReq = "SELECT MC.MC_Value 'Body'" _
         & "  FROM Web_MailComment MC" _
         & "  WHERE MC.M_ID = " & psID _
         & "    AND MTC_ID = 5"
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    ' Rcupration des adresses trouves
    If Not mo_Db.EOF(ll_Cursor) Then
        psText = mo_Db.GetFields(ll_Cursor, "Body")
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Exit Sub
    
ErrHandler:
    Call UpdateError(True)
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call UpdateRequest(psID, "F")
    Call AddToLog("Unable to define the customer parameters for changing password", psID)   ' extra error info
    Call UpdateError(False)

    Call ErrorHandler("GetPasswordParameters")

End Sub

' Dfinie les paramtres pour l'envoi d'un mail de type Binder
Private Sub GetBinderParameters(ByVal psID As String, ByRef psFrom As String, ByRef psDestTo As String, ByRef psDestCopy As String, ByRef psTitle As Variant, ByRef psBody As Variant, psAttachment() As String)
Dim lsReq       As String   ' Contient la requte  passer au serveur
Dim ll_Cursor   As Long
Dim lsText      As String
Dim liFile      As Integer
Dim lsHTML      As String

    On Error GoTo ErrHandler
    
    ' Requte pour rcuprer les destinataires du mail, de l'expditeur et son nom
    lsReq = "SELECT MO.MO_Value 'Value', MO.MTO_ID 'Type'" _
          & " FROM Web_MailObject MO" _
          & " WHERE MO.M_ID = " & psID _
          & "   AND MO.MTO_ID IN (3, 4, 5)"

    psDestTo = ""
    psDestCopy = ""
    psFrom = ""
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    ' Rcupration des adresses trouves
    While Not mo_Db.EOF(ll_Cursor)
        Select Case mo_Db.GetFields(ll_Cursor, "Type")
        Case "3"
            psDestTo = psDestTo & mo_Db.GetFields(ll_Cursor, "Value") & ", "
        Case "4"
            psFrom = mo_Db.GetFields(ll_Cursor, "Value")
        Case "5"
            lsText = mo_Db.GetFields(ll_Cursor, "Value")
        End Select
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    If psDestTo <> "" Then
        psDestTo = Left(psDestTo, Len(psDestTo) - 2)
    End If
    
    ' Requte pour rcuprer le sujet et le body
    lsReq = "SELECT MC.MC_Value 'Value', MC.MTC_ID 'Type'" _
          & " FROM Web_MailComment MC" _
          & " WHERE MC.M_ID = " & psID _
          & "   AND MC.MTC_ID IN (3, 4)"
    psTitle = ""
    psBody = ""
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    ' Rcupration des adresses trouves
    While Not mo_Db.EOF(ll_Cursor)
        Select Case mo_Db.GetFields(ll_Cursor, "Type")
        Case "3"
            psTitle = mo_Db.GetFields(ll_Cursor, "Value")
        Case "4"
            psBody = mo_Db.GetFields(ll_Cursor, "Value") & vbCrLf & vbCrLf & lsText
        End Select
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0

    ' Requte pour rcuprer le sujet, le body et la pice jointe
    lsReq = "SELECT MO.MO_Value 'Value', MO.MTO_ID 'Type'" _
          & " FROM Web_MailObject MO" _
          & " WHERE MO.M_ID = " & psID _
          & "   AND MO.MTO_ID = 7" _
          & "   ORDER BY Z_Creation"
    ReDim psAttachment(0) As String
    lsHTML = ""
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    ' Rcupration des adresses trouves
    While Not mo_Db.EOF(ll_Cursor)
        lsHTML = lsHTML & mo_Db.GetFields(ll_Cursor, "Value")
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    If lsHTML <> "" Then
        liFile = FreeFile
        Open App.Path & "\MailAttach.htm" For Output As #liFile
        Print #liFile, lsHTML
        Close #liFile
        psAttachment(0) = App.Path & "\MailAttach.htm"
    End If
    
    Exit Sub
    
ErrHandler:
    Call UpdateError(True)
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call UpdateRequest(psID, "F")
    Call AddToLog("Unable to define the customer parameters for binder", psID)   ' extra error info
    Call UpdateError(False)
    Call ErrorHandler(Extender.Name & ".GetBinderParameters")
End Sub

' Dfinie la liste des personnes chez Armstrong qui doivent recevoir le mail de notification
Private Sub DefineDestArmstrong(ByVal psID As String)
Dim lsReq       As String   ' Contient la requte  passer au serveur
Dim ll_Cursor   As Long
Dim i           As Integer

    On Error GoTo EndFunction
    
    ' Excution de la procdure stocke
    lsReq = "EXEC Web_ContactArmstrong_Sel " & psID

    ReDim msArmMail(2, 0) As String
    i = 0
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ' Rcupration du rsultats
    While Not mo_Db.EOF(ll_Cursor)
        ReDim Preserve msArmMail(2, i) As String
        msArmMail(0, i) = mo_Db.GetFields(ll_Cursor, "Address")
        msArmMail(1, i) = mo_Db.GetFields(ll_Cursor, "Type")
        msArmMail(2, i) = mo_Db.GetFields(ll_Cursor, "id")
        
        If msArmMail(0, i) = "" Then
            Call AddToLog("No email defined in Web_ContactArmstrong_Sel for id:" & msArmMail(2, i), psID)     ' log extra info
        End If
        
        i = i + 1
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    If i = 0 Then Call Err.Raise(ArmErr.CompFncFailed, "", "Unable to define the armstrong destination")
    Exit Sub

EndFunction:
    Call UpdateError(True)
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call UpdateRequest(psID, "F")
    Call AddToLog("Unable to define the armstrong destination", psID)     ' log extra info
    Call UpdateError(False)
    Call ErrorHandler(Extender.Name & ".DefineDestArmstrong")
End Sub

' Sauvegarde la liste des personnes qui ont reu la notification
Private Sub SaveArmstrongDest(ByVal psID As String, ByVal psDestList As String)
Dim lsReq       As String   ' Contient la requte  passer au serveur
    
    On Error GoTo EndFunction
    
    ' Excution de la procdure stocke
    lsReq = "INSERT INTO Web_MailDest" _
         & "  SELECT " & psID & ", CA.ID, 'To', GETDATE(), GETDATE(), 'sa', 1, 'X', 'N', NULL" _
         & "    FROM Web_ContactArmstrong CA" _
         & "    WHERE CA.ID IN (" & psDestList & ")"
    Call ExecuteSQLSafe(mo_Db, lsReq)
    
    Exit Sub
   
EndFunction:
    Call UpdateError(True)
    Call UpdateRequest(psID, "F")
    Call AddToLog("Unable to save armstrong mailing list", psID)     ' log extra info
    Call UpdateError(False)
    Call ErrorHandler(Extender.Name & ".SaveArmstrongDest")
End Sub

' Dfinie les paramtres d'un mail de rponse
Private Sub DefineResponseParam(ByVal psID As String, ByRef psTitle As Variant, ByRef psText As Variant, ByRef pscharset As String, ByRef psPath As String, ByRef psFrom As String, ByRef psPassword As String, ByRef psAR As String, ByRef psKeyFilename As String, ByRef psCertificateExpChecked As String, ByRef psMailFile As String, ByRef psLocation As String, ByRef psNewMailSeqNum As String, ByRef psAttachment() As String)
Dim lsReq       As String   ' Contient la requte  passer au serveur
Dim ll_Cursor   As Long
Dim i           As Integer

    On Error GoTo EndFunction
    
    ' Excution de la procdure stocke pour la rcupration des personne en destination directe
    lsReq = "SELECT MRD.MRD_Address 'Address'" _
         & " FROM Web_MailResponseDest MRD" _
         & " WHERE MRD.M_ID = " & psID _
         & "       AND MRD.MRD_Type = 'To'"

'    lsReq = "SELECT CA.CA_EMail 'Address'" _
'         & "  FROM Web_ContactArmstrong CA" _
'         & "  WHERE CA.ID IN (SELECT MRD.CA_ID" _
'         & "                    FROM Web_MailResponseDest MRD" _
'         & "                    WHERE MRD.M_ID = " & psID _
'         & "                      AND MRD.MRD_Type = 'To')"
    
    ReDim msDestMailTo(0) As String
    i = 0
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ' Rcupration des adresses trouves
    While Not mo_Db.EOF(ll_Cursor)
        ReDim Preserve msDestMailTo(i) As String
        msDestMailTo(i) = Replace(mo_Db.GetFields(ll_Cursor, "Address"), ";", ",")          ' JN 13/1/2014 to allow ; as address splitter
        i = i + 1
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0

    ' Excution de la procdure stocke pour la rcupration des personne en copie du mail
    lsReq = "SELECT MRD.MRD_Address 'Address'" _
         & " FROM Web_MailResponseDest MRD" _
         & " WHERE MRD.M_ID = " & psID _
         & "       AND MRD.MRD_Type = 'Copy'"
    
'    lsReq = "SELECT CA.CA_EMail 'Address'" _
'         & "  FROM Web_ContactArmstrong CA" _
'         & "  WHERE CA.ID IN (SELECT MRD.CA_ID" _
'         & "                    FROM Web_MailResponseDest MRD" _
'         & "                    WHERE MRD.M_ID = " & psID _
'         & "                      AND MRD.MRD_Type = 'Copy')"

    ReDim msDestMailCopy(0) As String
    i = 0
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ' Rcupration des adresses trouves
    While Not mo_Db.EOF(ll_Cursor)
        ReDim Preserve msDestMailCopy(i) As String
        msDestMailCopy(i) = Replace(mo_Db.GetFields(ll_Cursor, "Address"), ";", ",")        ' JN 13/1/2014 to allow ; as address splitter
        i = i + 1
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ' Excution de la procdure stocke pour la rcupration du destinataire et du charset
    lsReq = "SELECT ISNULL(MR.MR_Title, '') 'Title', ISNULL(MR.MR_Text, '') 'Text', CA.CA_EMail 'From', MR.MR_AR 'MailAR'" _
         & "  FROM Web_MailResponse MR" _
         & "    INNER JOIN Web_ContactArmstrong CA ON CA.ID=MR.CA_ID" _
         & "  WHERE MR.M_ID = " & psID
    
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ' Rcupration des donnes
    If mo_Db.EOF(ll_Cursor) Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
        Exit Sub
    Else
    '    psEMail = mo_Db.GetFields(ll_cursor, "Address")
    '    pscharset = rsResult("codepage")
        psTitle = mo_Db.GetFields(ll_Cursor, "Title")
        psText = mo_Db.GetFields(ll_Cursor, "Text")
        psAR = mo_Db.GetFields(ll_Cursor, "MailAR")
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ' Excution de la procdure stocke pour la rcupration de l'adresse E-Mail pour la rponse
    lsReq = "SELECT ISNULL(SMK.SMK_Path, '') 'Path', SMK.SMK_Name 'Name', SMK.SMK_Password 'Password'," _
         & " ISNULL(SMK.SMK_KeyFilename, '') 'KeyFilename', ISNULL(SMK.SMK_CertificateExpChecked, '') 'CertificateExpChecked'," _
         & " ISNULL(SMK.SMK_MailFile, '') 'MailFile', ISNULL(SMK.SMK_Location, '') 'Location'," _
         & " ISNULL(SMK.SMK_NewMailSeqNum, '') 'NewMailSeqNum'" _
         & " FROM Web_Mail M," _
         & " Web_CUS_PRF CP," _
         & " Countries_Sales_Markets CSM," _
         & " Web_SalesMarketsMail SMK" _
         & " WHERE M.M_ID = " & psID _
         & " AND CP.CUS_ID = M.CUS_ID" _
         & " AND CP.PRF_ID = 17" _
         & " AND CP.Number = 1" _
         & " AND CSM.CT_Code = CP.CP_Value" _
         & " AND SMK.SMK_Code = CSM.SMK_Code AND SMK.drop_flag='N'"

    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ' Rcupration des donnes
    If mo_Db.EOF(ll_Cursor) Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
        lsReq = "SELECT ISNULL(SMK.SMK_Path, '') 'Path', SMK.SMK_Name 'Name', SMK.SMK_Password 'Password'," _
             & " ISNULL(SMK.SMK_KeyFilename, '') 'KeyFilename', ISNULL(SMK.SMK_CertificateExpChecked, '') 'CertificateExpChecked'," _
             & " ISNULL(SMK.SMK_MailFile, '') 'MailFile', ISNULL(SMK.SMK_Location, '') 'Location'," _
             & " ISNULL(SMK.SMK_NewMailSeqNum, '') 'NewMailSeqNum'" _
             & " FROM Web_Mail M," _
             & " Web_CUS_PRF CP," _
             & " Web_SalesMarketsMail SMK" _
             & " WHERE M.M_ID = " & psID _
             & " AND CP.CUS_ID = M.CUS_ID" _
             & " AND CP.PRF_ID = 18" _
             & " AND CP.Number = 1" _
             & " AND SMK.SMK_Code = CP.CP_Value AND SMK.drop_flag='N'"
        ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
        If mo_Db.EOF(ll_Cursor) Then
            Call mo_Db.Close(ll_Cursor)
            ll_Cursor = 0
            Exit Sub
        Else
            psPath = mo_Db.GetFields(ll_Cursor, "Path")
            psFrom = mo_Db.GetFields(ll_Cursor, "Name")
            psPassword = mo_Db.GetFields(ll_Cursor, "Password")
            psKeyFilename = mo_Db.GetFields(ll_Cursor, "KeyFilename")
            psCertificateExpChecked = mo_Db.GetFields(ll_Cursor, "CertificateExpChecked")
            psMailFile = mo_Db.GetFields(ll_Cursor, "MailFile")
            psLocation = mo_Db.GetFields(ll_Cursor, "Location")
            psNewMailSeqNum = mo_Db.GetFields(ll_Cursor, "NewMailSeqNum")
        End If
    Else
        psPath = Trim(mo_Db.GetFields(ll_Cursor, "Path"))
        psFrom = mo_Db.GetFields(ll_Cursor, "Name")
        psPassword = mo_Db.GetFields(ll_Cursor, "Password")
        psKeyFilename = mo_Db.GetFields(ll_Cursor, "KeyFilename")
        psCertificateExpChecked = mo_Db.GetFields(ll_Cursor, "CertificateExpChecked")
        psMailFile = mo_Db.GetFields(ll_Cursor, "MailFile")
        psLocation = mo_Db.GetFields(ll_Cursor, "Location")
        psNewMailSeqNum = mo_Db.GetFields(ll_Cursor, "NewMailSeqNum")
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ' Requte rcuprant la liste des pices jointes
    lsReq = "SELECT MRA.MRA_File 'FileName', MRA.MRA_OriginFileName 'LogicName'" _
         & "  FROM Web_MailResponseAttachment MRA" _
         & "  WHERE MRA.M_ID = " & psID
    
    ReDim psAttachment(1, 0) As String
    i = 0
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ' Rcupration des pices jointes trouves
    While Not mo_Db.EOF(ll_Cursor)
        ReDim Preserve psAttachment(1, i) As String
        psAttachment(0, i) = mo_Db.GetFields(ll_Cursor, "FileName")
        psAttachment(1, i) = mo_Db.GetFields(ll_Cursor, "LogicName")
        i = i + 1
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Exit Sub
    
EndFunction:
    Call UpdateError(True)
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call UpdateRequest(psID, "F")
    Call AddToLog("Unable to define the Parameters for the response", psID)     ' log extra info
    Call UpdateError(False)
    Call ErrorHandler(Extender.Name & ".DefineResponseParam")
    
End Sub

' Dfinie les pices jointes d'un mail de forward
Private Sub DefineForwardParam(ByVal psID As String, ByRef psAttachment() As String)
Dim lsReq       As String   ' Contient la requte  passer au serveur
Dim ll_Cursor   As Long
Dim i           As Integer

On Error GoTo ErrHandler
    
    ' Excution de la procdure stocke pour la rcupration des personne en destination directe
    lsReq = "SELECT MFD.MFD_Address 'Address'" _
         & "  FROM Web_MailForwardDest MFD" _
         & "  WHERE MFD.MF_ID = " & psID _
         & "    AND MFD.MFD_Type = 'To'"

    ReDim msDestMailTo(0) As String
    i = 0
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ' Rcupration des adresses trouves
    While Not mo_Db.EOF(ll_Cursor)
        ReDim Preserve msDestMailTo(i) As String
        msDestMailTo(i) = Replace(mo_Db.GetFields(ll_Cursor, "Address"), ";", ",")          ' JN 13/1/2014 to allow ; as address splitter
        i = i + 1
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0

    ' Excution de la procdure stocke pour la rcupration des personne en copie du mail
    lsReq = "SELECT MFD.MFD_Address 'Address'" _
         & "  FROM Web_MailForwardDest MFD" _
         & "  WHERE MFD.MF_ID = " & psID _
         & "    AND MFD.MFD_Type = 'Copy'"

    ReDim msDestMailCopy(0) As String
    i = 0
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ' Rcupration des adresses trouves
    While Not mo_Db.EOF(ll_Cursor)
        ReDim Preserve msDestMailCopy(i) As String
        msDestMailCopy(i) = Replace(mo_Db.GetFields(ll_Cursor, "Address"), ";", ",")          ' JN 13/1/2014 to allow ; as address splitter
        i = i + 1
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ' Requte rcuprant la liste des pices jointes
    lsReq = "   SELECT DISTINCT" _
            & "   CASE ISNULL(MR.M_ID,0) WHEN 0 THEN MA.MA_File ELSE MRA.MRA_File END AS 'FileName'," _
            & "   CASE ISNULL(MR.M_ID,0) WHEN 0 THEN MA.MA_OriginFileName ELSE MRA.MRA_OriginFileName END AS 'LogicName'" _
            & " FROM Web_MailForward MF" _
            & "   LEFT JOIN Web_MailResponse MR ON MR.M_ID = MF.M_ID" _
            & "   LEFT JOIN Web_MailAttachment MA ON MA.M_ID = MF.M_ID" _
            & "   LEFT JOIN Web_MailResponseAttachment MRA ON MRA.M_ID = MF.M_ID" _
            & " WHERE MF.MF_ID =" & psID

    ReDim psAttachment(1, 0) As String
    i = 0
    ll_Cursor = OpenSQLSafe(mo_Db, lsReq)
    
    ' Rcupration des pices jointes trouves
    While Not mo_Db.EOF(ll_Cursor)
        If mo_Db.GetFields(ll_Cursor, "FileName") <> "" Then
            ReDim Preserve psAttachment(1, i) As String
            psAttachment(0, i) = mo_Db.GetFields(ll_Cursor, "FileName")
            psAttachment(1, i) = mo_Db.GetFields(ll_Cursor, "LogicName")
            i = i + 1
        End If
        mo_Db.Next (ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Exit Sub
    
ErrHandler:
    Call UpdateError(True)
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call UpdateForwardRequest(psID, "F")
    Call AddToLog("Unable to define the Parameters for the forward", psID)  ' extra info

    Call UpdateError(False)
    Call ErrorHandler(Extender.Name & ".DefineForwardParam")

End Sub


' Modifie le status d'un forward de mail dans la base
Private Sub UpdateForwardRequest(ByVal psID As String, ByRef psStatus As String)
Dim lsReq       As String   ' Contient la requte  passer au serveur
    
On Error GoTo ErrHandler
    
    ' Excution de la procdure stocke
    lsReq = "UPDATE Web_MailForward SET MF_Status = '" & psStatus & "' WHERE MF_ID = " & psID
    
    Call ExecuteSQLSafe(mo_Db, lsReq)
    
    Exit Sub
   
ErrHandler:

    Call AddToLog("Unable to update the status to " & psStatus, psID)   ' extra information log
    If psStatus <> "F" Then
        Call ErrorHandler(Extender.Name & ".UpdateForwardRequest")
    Else
        ' in this case we will not propagate error to upper level, just log information
        Call AddToLog(App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:UpdateForwardRequest" & SEP1 & Err.Source & ", Err.Description " & Err.Description & ".", psID)
    End If
End Sub

Public Function ParseXML(ByVal as_IMTID As String, ByVal as_filePath As String) As Boolean
On Error GoTo ErrHandler
Const REQ As String = "  SELECT  WMIT.Sort_order, " & _
                                "WMIT.Node, " & _
                                "WMIT.Field, " & _
                                "WMIT.DST_Table, " & _
                                "WMIT.DST_Fields, " & _
                                "WMIT.Manipulation " & _
                        "FROM WM_IncomingMailTemplate WMIT " & _
                        "WHERE IMT_ID=$IMTID$ AND WMIT.IMT_Type='A' AND WMIT.FileName='$FILENAME$' AND WMIT.Manipulation<>''" & _
                        "ORDER BY WMIT.Sort_order"
    
    Dim lo_xmlDoc       As MSXML2.DOMDocument30
    Dim lo_currNode     As MSXML2.IXMLDOMNode
    Dim lo_currDataNode As MSXML2.IXMLDOMNode
    Dim lo_nodeList     As MSXML2.IXMLDOMNodeList
    Dim lo_dataNodeList As MSXML2.IXMLDOMNodeList
    Dim ll_Cursor       As Long
    Dim ls_req          As String
    Dim ls_field        As String
    Dim ls_value        As String
    Dim ls_appendVal    As String
    Dim ll_aktIndex     As Long
    Dim lb_ret          As Boolean
    
    lb_ret = False
    
    ' parse file
    ' select all template fields for parsed file
    ls_req = Replace(REQ, "$IMTID$", as_IMTID)
    ls_req = Replace(ls_req, "$FILENAME$", mo_FSO.GetBaseName(as_filePath))
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    If Not mo_Db.EOF(ll_Cursor) Then
        Set lo_xmlDoc = New MSXML2.DOMDocument30
        
        lo_xmlDoc.async = False
        If Not lo_xmlDoc.Load(as_filePath) Then
            Call mo_Db.Close(ll_Cursor)
            ll_Cursor = 0
            Call AddToLog("Error in " & as_filePath & ". line:" & lo_xmlDoc.parseError.Line & " pos:" & lo_xmlDoc.parseError.linepos & " reason:" & lo_xmlDoc.parseError.reason & " srcText:" & lo_xmlDoc.parseError.srcText, IIf(IsEmpty(getPlaceholderVal("Web_Mail.M_ID")), "0", IsEmpty(getPlaceholderVal("Web_Mail.M_ID"))), vbTab & "Warning:")
            ParseXML = lb_ret
            Exit Function
'            Call Err.Raise(FileLoadFailed, "lo_xmlDoc.Load", as_filePath & " line:" & lo_xmlDoc.parseError.Line & " pos:" & lo_xmlDoc.parseError.linepos & " reason:" & lo_xmlDoc.parseError.reason & " srcText:" & lo_xmlDoc.parseError.srcText)
        End If
        
        Call lo_xmlDoc.setProperty("SelectionLanguage", "XPath")

        ls_value = ""
        While Not mo_Db.EOF(ll_Cursor)
            Set lo_nodeList = lo_xmlDoc.documentElement.selectNodes(mo_Db.GetFields(ll_Cursor, "Node"))
            ll_aktIndex = 1
            For Each lo_currNode In lo_nodeList
                ls_appendVal = ""
                If mo_Db.GetFields(ll_Cursor, "Field") <> "" Then
                    Set lo_dataNodeList = lo_currNode.selectNodes(mo_Db.GetFields(ll_Cursor, "Field"))
                    For Each lo_currDataNode In lo_dataNodeList
                        ' get data from Text value of XML Node
                        ls_value = getDataTransposed(as_IMTID, mo_Db.GetFields(ll_Cursor, "Sort_order"), lo_currDataNode.Text)
                        ' value will be known also as name of node in placeholder array
                        Call setPlaceholderVal(lo_currDataNode.nodeName, ls_value)
                        
                        Select Case mo_Db.GetFields(ll_Cursor, "Manipulation")
                        Case "I"        ' insert field into DB
                            ' replace placeholders and retriev fields to insert into table
                            Call setPlaceholderVal("COUNTER", ll_aktIndex)
                            Call insertData(ls_value, mo_Db.GetFields(ll_Cursor, "DST_Table"), mo_Db.GetFields(ll_Cursor, "DST_Fields"))
                            
                            ll_aktIndex = ll_aktIndex + 1
                        Case "A", "B"
                            ' concat values
                            ls_appendVal = IIf(ls_appendVal = "", "", ls_appendVal & ", ") & ls_value
                        Case "U"
                            ' update value for existing record in db
                            Call setPlaceholderVal("COUNTER", ll_aktIndex)
                            Call updateData(ls_value, mo_Db.GetFields(ll_Cursor, "DST_Table"), mo_Db.GetFields(ll_Cursor, "DST_Fields"))
                        Case Else
                            Debug.Assert (False)
                        End Select
                    Next
                End If
                
                
                Select Case mo_Db.GetFields(ll_Cursor, "Manipulation")
                Case "I", "U"       ' data are already inserted/updated
                Case "A"
                    ' insert concatinated values
                    Call setPlaceholderVal("COUNTER", ll_aktIndex)
                    Call insertData(ls_appendVal, mo_Db.GetFields(ll_Cursor, "DST_Table"), mo_Db.GetFields(ll_Cursor, "DST_Fields"))
                           
                    ll_aktIndex = ll_aktIndex + 1
                Case "B"
                    ' apend concatinated values
                    Call setPlaceholderVal("COUNTER", ll_aktIndex)
                    Call updateData(ls_appendVal, mo_Db.GetFields(ll_Cursor, "DST_Table"), mo_Db.GetFields(ll_Cursor, "DST_Fields"))
                    
                    ll_aktIndex = ll_aktIndex + 1
                Case Else
                    Debug.Assert (False)
                End Select
            Next
            
            Call mo_Db.Next(ll_Cursor)
        Wend
        Set lo_xmlDoc = Nothing
        lb_ret = True
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ParseXML = lb_ret
    Exit Function
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Set lo_xmlDoc = Nothing
    Call ErrorHandler(Extender.Name & ".ParseXML")
End Function

Private Sub insertData(ByVal as_Value As String, ByVal as_DST_Table As String, ByVal as_DST_Fields As String)
On Error GoTo ErrHandler
Const REQ_PK_SEL As String = "select col.name as COLUMN_NAME, col.colstat as IS_AUTOINCREMENT " & _
                            " from sysobjects c_obj " & _
                            "    inner join sysobjects t_obj on t_obj.id = c_obj.parent_obj and t_obj.xtype = 'U' " & _
                            "    inner join sysindexes i on t_obj.id = i.id and c_obj.name = i.name " & _
                            "    inner join A_References_ML ARML on ARML.GR_code=2 and ARML.RF_code<=i.keycnt " & _
                            "    inner join syscolumns col on col.name = index_col(t_obj.name,i.indid,ARML.RF_code) and t_obj.id = col.id " & _
                            " where " & _
                            "    permissions(t_obj.id) != 0 " & _
                            "    and c_obj.xtype = 'PK' " & _
                            "    and t_obj.name = '$TABLE_NAME$'"

Const REQ_INSERT As String = "INSERT INTO $TABLE$ ($FIELDS$) VALUES ($VALUES$)"
    
    Dim ll_fieldsCursor     As Long
    Dim ll_PKCursor         As Long
    Dim lv_fieldsVal        As Variant
    Dim ls_req              As String
    Dim ls_fieldAutoInc     As String
    Dim ll_fieldIndex       As Long

    Call setPlaceholderVal("VALUE", as_Value)

    ll_fieldsCursor = OpenSQLSafe(mo_Db, replacePlaceholders(as_DST_Fields))
    Debug.Assert (ll_fieldsCursor <> 0)
        
    ' convert data back to SQL safe values
    lv_fieldsVal = SQLSafeFromCursor(ll_fieldsCursor)
    
    ' get primary keys beeing inserted via insert statement and define placeholder
    ll_PKCursor = OpenSQLSafe(mo_Db, Replace(REQ_PK_SEL, "$TABLE_NAME$", as_DST_Table))
    ls_fieldAutoInc = ""
    While Not mo_Db.EOF(ll_PKCursor)
        ll_fieldIndex = mo_Db.GetFieldIndex(ll_fieldsCursor, mo_Db.GetFields(ll_PKCursor, "COLUMN_NAME"))
        If ll_fieldIndex <> -1 Then
            ' KEY will be contained in INSERT statement
            Call setPlaceholderVal(as_DST_Table & "." & mo_Db.GetFields(ll_PKCursor, "COLUMN_NAME"), lv_fieldsVal(ll_fieldIndex))
        Else
            ' KEY is probably autoincrement
            Debug.Assert (mo_Db.GetFields(ll_PKCursor, "IS_AUTOINCREMENT") = 1)
            ls_fieldAutoInc = as_DST_Table & "." & mo_Db.GetFields(ll_PKCursor, "COLUMN_NAME")
        End If
        Call mo_Db.Next(ll_PKCursor)
    Wend
    Call mo_Db.Close(ll_PKCursor)
    ll_PKCursor = 0
    
    ls_req = Replace(REQ_INSERT, "$TABLE$", as_DST_Table)
    ls_req = Replace(ls_req, "$FIELDS$", Join(mo_Db.Fields(ll_fieldsCursor), ","))
    ls_req = Replace(ls_req, "$VALUES$", Join(lv_fieldsVal, ","))
    Call mo_Db.Close(ll_fieldsCursor)
    ll_fieldsCursor = 0
    
    ' execute statement
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    If ls_fieldAutoInc <> "" Then
        ' key is autoincrement value
        ll_PKCursor = OpenSQLSafe(mo_Db, "SELECT @@IDENTITY AS newID")
        Debug.Assert (Not mo_Db.EOF(ll_PKCursor))
        If mo_Db.GetFields(ll_PKCursor, "newID") <> 0 Then
            Call setPlaceholderVal(ls_fieldAutoInc, mo_Db.GetFields(ll_PKCursor, "newID"))
        Else
            ' expecting some autoincrement key, but non returned - IT IS ERROR
            Debug.Assert (False)
        End If
        Call mo_Db.Close(ll_PKCursor)
        ll_PKCursor = 0
    End If

    Exit Sub
ErrHandler:
    If ll_PKCursor <> 0 Then
        Call mo_Db.Close(ll_PKCursor)
        ll_PKCursor = 0
    End If
    If ll_fieldsCursor <> 0 Then
        Call mo_Db.Close(ll_fieldsCursor)
        ll_fieldsCursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".insertData")
End Sub

Private Sub updateData(ByVal as_Value As String, ByVal as_DST_Table As String, ByVal as_DST_Fields As String)
On Error GoTo ErrHandler
Const REQ_PK_SEL As String = "select col.name as COLUMN_NAME, col.colstat as IS_AUTOINCREMENT " & _
                            " from sysobjects c_obj " & _
                            "    inner join sysobjects t_obj on t_obj.id = c_obj.parent_obj and t_obj.xtype = 'U' " & _
                            "    inner join sysindexes i on t_obj.id = i.id and c_obj.name = i.name " & _
                            "    inner join A_References_ML ARML on ARML.GR_code=2 and ARML.RF_code<=i.keycnt " & _
                            "    inner join syscolumns col on col.name = index_col(t_obj.name,i.indid,ARML.RF_code) and t_obj.id = col.id " & _
                            " where " & _
                            "    permissions(t_obj.id) != 0 " & _
                            "    and c_obj.xtype = 'PK' " & _
                            "    and t_obj.name = '$TABLE_NAME$'"

Const REQ_UPDATE As String = "UPDATE $TABLE$ SET $SET$ WHERE $CONDITION$"
    
    Dim ll_fieldsCursor     As Long
    Dim ll_PKCursor         As Long
    Dim lv_fieldsVal        As Variant
    Dim lv_fields           As Variant
    Dim ls_condition        As String
    Dim ls_set              As String
    Dim ls_req              As String
    Dim ll_fieldIndex       As Long

    Call setPlaceholderVal("VALUE", as_Value)

    ll_fieldsCursor = OpenSQLSafe(mo_Db, replacePlaceholders(as_DST_Fields))
    Debug.Assert (ll_fieldsCursor <> 0)
        
    ' convert data back to SQL safe values
    lv_fieldsVal = SQLSafeFromCursor(ll_fieldsCursor)
    
    ' get primary keys beeing inserted via insert statement and define placeholder
    ll_PKCursor = OpenSQLSafe(mo_Db, Replace(REQ_PK_SEL, "$TABLE_NAME$", as_DST_Table))
    ls_condition = ""
    While Not mo_Db.EOF(ll_PKCursor)
        ll_fieldIndex = mo_Db.GetFieldIndex(ll_fieldsCursor, mo_Db.GetFields(ll_PKCursor, "COLUMN_NAME"))
        If ll_fieldIndex <> -1 Then
            ' KEY will be contained in CONDITION part
            Call setPlaceholderVal(as_DST_Table & "." & mo_Db.GetFields(ll_PKCursor, "COLUMN_NAME"), lv_fieldsVal(ll_fieldIndex))
            ls_condition = ls_condition & IIf(ls_condition = "", "", " AND ") & mo_Db.GetFields(ll_PKCursor, "COLUMN_NAME") & "=" & lv_fieldsVal(ll_fieldIndex)
            ' do not use it in SET clause
            lv_fieldsVal(ll_fieldIndex) = Empty
        Else
            ' KEY is not provided within select statment, this is ERROR
            Debug.Assert (False)
        End If
        Call mo_Db.Next(ll_PKCursor)
    Wend
    Call mo_Db.Close(ll_PKCursor)
    ll_PKCursor = 0
    
    lv_fields = mo_Db.Fields(ll_fieldsCursor)
    Debug.Assert (UBound(lv_fields) = UBound(lv_fieldsVal))
    
    ' generate SET clause
    For ll_fieldIndex = LBound(lv_fieldsVal) To UBound(lv_fieldsVal)
        If Not IsEmpty(lv_fieldsVal(ll_fieldIndex)) Then
            ls_set = ls_set & IIf(ls_set = "", "", ",") & lv_fields(ll_fieldIndex) & "=" & lv_fieldsVal(ll_fieldIndex)
        End If
    Next
    
    
    ls_req = Replace(REQ_UPDATE, "$TABLE$", as_DST_Table)
    ls_req = Replace(ls_req, "$SET$", ls_set)
    ls_req = Replace(ls_req, "$CONDITION$", ls_condition)
    Call mo_Db.Close(ll_fieldsCursor)
    ll_fieldsCursor = 0
    
    ' execute statement
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Exit Sub
ErrHandler:
    If ll_PKCursor <> 0 Then
        Call mo_Db.Close(ll_PKCursor)
        ll_PKCursor = 0
    End If
    If ll_fieldsCursor <> 0 Then
        Call mo_Db.Close(ll_fieldsCursor)
        ll_fieldsCursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".updateData")
End Sub

Private Function getDataTransposed(ByVal as_IMTID As String, ByVal as_order As String, ByVal as_IValue As String) As String
On Error GoTo ErrHandler
Const REQ As String = "SELECT WMIDT.R_Value " & _
                    "   FROM WM_IncomingData_Transposition WMIDT " & _
                    "   WHERE WMIDT.IMT_ID=$IMTID$ AND WMIDT.Sort_order=$ORDER$ AND WMIDT.I_Value=N'$IVALUE$'"
    Dim ll_Cursor   As Long
    Dim ls_req      As String
    
    getDataTransposed = as_IValue
    ls_req = Replace(REQ, "$IMTID$", as_IMTID)
    ls_req = Replace(ls_req, "$ORDER$", as_order)
    ls_req = Replace(ls_req, "$IVALUE$", SqlStr(as_IValue))
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    If Not mo_Db.EOF(ll_Cursor) Then
        getDataTransposed = mo_Db.GetFields(ll_Cursor, "R_Value")
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Exit Function
ErrHandler:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".getDataTransposed")
End Function

' set value for specified ID into mva_placeHolders array
Private Sub setPlaceholderVal(ByVal as_ID As String, ByVal av_val As Variant)
On Error GoTo ErrHandler
    Dim ll_i As Long
    For ll_i = 0 To UBound(mva_placeHolders)
        If mva_placeHolders(ll_i)(0) = as_ID Then
            mva_placeHolders(ll_i)(1) = av_val
            Exit Sub
        End If
    Next ll_i
    
    ' insert new placeholder
    ReDim Preserve mva_placeHolders(UBound(mva_placeHolders) + 1) As Variant
    mva_placeHolders(UBound(mva_placeHolders)) = Array(as_ID, av_val)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".setPlaceholderVal")
End Sub

' get value for specified ID from mva_placeHolders array
Private Function getPlaceholderVal(ByVal as_ID As String) As Variant
On Error GoTo ErrHandler
    Dim ll_i As Long
    For ll_i = 0 To UBound(mva_placeHolders)
        If mva_placeHolders(ll_i)(0) = as_ID Then
            getPlaceholderVal = mva_placeHolders(ll_i)(1)
            Exit For
        End If
    Next ll_i
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".getPlaceholderVal")
End Function

Private Function replacePlaceholders(ByVal as_src As String) As String
On Error GoTo ErrHandler
    as_src = Replace(as_src, "$CHARSET$", msDefaultcharset)
    
    Dim ll_i As Long
    For ll_i = 0 To UBound(mva_placeHolders)
        as_src = Replace(as_src, "$" & mva_placeHolders(ll_i)(0) & "$", SqlStr(mva_placeHolders(ll_i)(1)))
    Next ll_i
    replacePlaceholders = as_src
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".replacePlaceholders")
End Function

' task 376 begin JN
Private Sub DefineSpam()
On Error GoTo ErrHandler
        
Dim sSQL        As String   ' Contient la requte  passer au serveur
Dim ll_Cursor   As Long     ' Recordset contenant le rsultat final

On Error GoTo ErrHandler
    
    sSQL = "EXEC A_Config_sel 'MS_SPAM'"
    ll_Cursor = OpenSQLSafe(mo_Db, sSQL)
    
    If Not mo_Db.EOF(ll_Cursor) Then
        mva_spamArray = Split(mo_Db.GetFields(ll_Cursor, "CFG_Value"), SEP)
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    If Not IsArray(mva_spamArray) Then
        mva_spamArray = Array()
    End If
    Exit Sub
ErrHandler:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".DefineSpam")
End Sub


' use global variable mva_spamArray
Private Function GetStatusForNewMail(ByVal as_subject As String) As String
On Error GoTo ErrHandler
    Debug.Assert (IsArray(mva_spamArray))
    Dim ls_spam As Variant
    Dim ls_retVal As String
    ls_retVal = "N"                     ' New

    For Each ls_spam In mva_spamArray
        If InStr(1, as_subject, ls_spam) > 0 Then
            ls_retVal = "D"             ' Deleted
            Exit For
        End If
    Next
    GetStatusForNewMail = ls_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetStatusForNewMail")
End Function
' task 376 end
' **************************** FRAMEWORK FUNCTIONS ***********************************


' ************************************************************************************
' ************************** EVENT HANDLER FUNCTIONS *********************************
' ************************************************************************************
Private Sub cmdClose_Click()
    RaiseEvent quit
End Sub

Private Sub cmd_Reset_Click()
On Error GoTo ErrHandler
    
    ml_OneUser = 0
    lbl_OneUser.Caption = "Mails sent to only one user : " & ml_OneUser
    txtLog.Text = ""
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".cmd_Reset_Click")
End Sub

Private Sub cmd_Pause_Click()
On Error GoTo ErrHandler

    tmr_Check.Enabled = False
    cmd_Pause.Enabled = False
    cmd_Play.Enabled = True

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".cmd_Pause_Click")
End Sub

Private Sub cmd_Play_Click()
On Error GoTo ErrHandler

    tmr_Check.Enabled = True
    cmd_Pause.Enabled = True
    cmd_Play.Enabled = False

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".cmd_Play_Click")
End Sub

Private Sub mo_Exchange_ArmGraphError(ll_errNr As Long, ls_ErrSource As String, ls_ErrDesc As String, ls_fnc As String)
    Call AddToLog(ls_fnc & ": Error " & ll_errNr & "," & ls_ErrSource & "," & ls_ErrDesc, "0")
End Sub

' Une fois sur deux vrifie dans la base de donnes si un client a dpos une nouvelle requte
' depuis le site web et une fois sur deux scrute une messagerie pour voir ses des nouveaux mails
' sont arrivs directement
Private Sub tmr_Check_Timer()
Dim lsID                As String   ' ID du mail  traiter
Dim lsStatus            As String   ' Status du mail
Dim llcharset          As Long
Dim lsNextStatus        As String   ' Futur status du mail
Dim lsOperation         As String   ' Libell de la tache
Dim lsMFList()          As String   ' Liste des ID des mails  forwarder
Dim i                   As Integer

On Error GoTo ErrHandler

    tmr_Check.Enabled = False
    
    cmdClose.Enabled = False
    
    If CheckConnection(mo_Db) = True Then
        Call mo_HeartBeat.HeartBeatHit(mo_Db, C_PROCESSNAME)
    End If
    
    lsStatus = ""                       ' JN init value to indicate nothing is processing
    lsID = ""
    
'    mbProgID = False
    If mbProgID Then
        Call CheckMailBox
    Else
        lbl_Task = "Actual task: Scanning SQL Server"

        If GetRequest(lsID, lsStatus) Then
            
            Select Case lsStatus
            Case "N" ' Nouvelle ligne dans la base (nouveau mail)
                lsNextStatus = "I" ' Status "Personnel Armstrong inform"
            Case "V" ' Nouvelle rponse en provenance d'Armstrong
                lsNextStatus = "V" ' Status "Mail rpondu"
            Case "S" ' Nouveau transfert de mail
                lsNextStatus = "R" ' Status "Mail rpondu"
            End Select
            Select Case lsStatus
            Case "N", "V"
                Call UpdateRequest(lsID, lsNextStatus)
                Call Generator(lsID, lsStatus)
            Case "S"
                Call GetForwardList(lsID, lsMFList())
                For i = 0 To UBound(lsMFList)
                    'Call UpdateForwardRequest(lsMFList(i), "T")
                    '23.2.2011 - mw - this is called from GeneratorForward function
                    'if called from here it can cause incorect email settings if GeneratorForward crashes
                    Call GeneratorForward(lsMFList(i))
                Next i
                Call UpdateRequest(lsID, lsNextStatus)
            End Select
        End If
    End If
    
    mbProgID = Not (mbProgID)
    
    cmdClose.Enabled = True
    tmr_Check.Enabled = True
    Exit Sub
    
ErrHandler:
    txtLog.Text = Left("    " & "error during timer event : " & Err.Number & ", " & Err.Description & vbCrLf & txtLog.Text, C_LOGTXTMAX)
    cmdClose.Enabled = True
    tmr_Check.Enabled = True

    ' 13/1/2014 JN SWAP the route of timer in case of error
    mbProgID = Not (mbProgID)
    
    Dim ls_ErrSource As String
    Dim ls_ErrDescription As String
    Dim ll_errnum As Long
    
    ' 13/1/2014 JN if the failure apear during processing the email in SQL update iconcurrency of a email
    If lsID <> "" Then
        ls_ErrSource = Err.Source
        ls_ErrDescription = Err.Description
        ll_errnum = Err.Number
        Call UpdateIconc(lsID)
        Err.Source = ls_ErrSource
        Err.Description = ls_ErrDescription
        Err.Number = ll_errnum
    End If
    
' do not display message
    Call ErrorMessage(Extender.Name & ".tmr_Check_Timer", False)

End Sub

' ************************** EVENT HANDLER FUNCTIONS *********************************

